package software.amazon.awscdk.services.wisdom;

/**
 * A reference to a Assistant resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * AssistantReference assistantReference = AssistantReference.builder()
 *         .assistantArn("assistantArn")
 *         .assistantId("assistantId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.012Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.AssistantReference")
@software.amazon.jsii.Jsii.Proxy(AssistantReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssistantReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Assistant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantArn();

    /**
     * The AssistantId of the Assistant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * @return a {@link Builder} of {@link AssistantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssistantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssistantReference> {
        java.lang.String assistantArn;
        java.lang.String assistantId;

        /**
         * Sets the value of {@link AssistantReference#getAssistantArn}
         * @param assistantArn The ARN of the Assistant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantArn(java.lang.String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        /**
         * Sets the value of {@link AssistantReference#getAssistantId}
         * @param assistantId The AssistantId of the Assistant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssistantReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssistantReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssistantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssistantReference {
        private final java.lang.String assistantArn;
        private final java.lang.String assistantId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assistantArn = software.amazon.jsii.Kernel.get(this, "assistantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assistantArn = java.util.Objects.requireNonNull(builder.assistantArn, "assistantArn is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
        }

        @Override
        public final java.lang.String getAssistantArn() {
            return this.assistantArn;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assistantArn", om.valueToTree(this.getAssistantArn()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.AssistantReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssistantReference.Jsii$Proxy that = (AssistantReference.Jsii$Proxy) o;

            if (!assistantArn.equals(that.assistantArn)) return false;
            return this.assistantId.equals(that.assistantId);
        }

        @Override
        public final int hashCode() {
            int result = this.assistantArn.hashCode();
            result = 31 * result + (this.assistantId.hashCode());
            return result;
        }
    }
}
