package software.amazon.awscdk.services.wisdom;

/**
 * A reference to a MessageTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * MessageTemplateReference messageTemplateReference = MessageTemplateReference.builder()
 *         .messageTemplateArn("messageTemplateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.101Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.MessageTemplateReference")
@software.amazon.jsii.Jsii.Proxy(MessageTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MessageTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The MessageTemplateArn of the MessageTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMessageTemplateArn();

    /**
     * @return a {@link Builder} of {@link MessageTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MessageTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MessageTemplateReference> {
        java.lang.String messageTemplateArn;

        /**
         * Sets the value of {@link MessageTemplateReference#getMessageTemplateArn}
         * @param messageTemplateArn The MessageTemplateArn of the MessageTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageTemplateArn(java.lang.String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MessageTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MessageTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MessageTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageTemplateReference {
        private final java.lang.String messageTemplateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.messageTemplateArn = software.amazon.jsii.Kernel.get(this, "messageTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.messageTemplateArn = java.util.Objects.requireNonNull(builder.messageTemplateArn, "messageTemplateArn is required");
        }

        @Override
        public final java.lang.String getMessageTemplateArn() {
            return this.messageTemplateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("messageTemplateArn", om.valueToTree(this.getMessageTemplateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.MessageTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MessageTemplateReference.Jsii$Proxy that = (MessageTemplateReference.Jsii$Proxy) o;

            return this.messageTemplateArn.equals(that.messageTemplateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.messageTemplateArn.hashCode();
            return result;
        }
    }
}
