package software.amazon.awscdk.services.workspacesweb;

/**
 * Properties for defining a <code>CfnPortal</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnPortalProps cfnPortalProps = CfnPortalProps.builder()
 *         .additionalEncryptionContext(Map.of(
 *                 "additionalEncryptionContextKey", "additionalEncryptionContext"))
 *         .authenticationType("authenticationType")
 *         .browserSettingsArn("browserSettingsArn")
 *         .customerManagedKey("customerManagedKey")
 *         .dataProtectionSettingsArn("dataProtectionSettingsArn")
 *         .displayName("displayName")
 *         .instanceType("instanceType")
 *         .ipAccessSettingsArn("ipAccessSettingsArn")
 *         .maxConcurrentSessions(123)
 *         .networkSettingsArn("networkSettingsArn")
 *         .sessionLoggerArn("sessionLoggerArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trustStoreArn("trustStoreArn")
 *         .userAccessLoggingSettingsArn("userAccessLoggingSettingsArn")
 *         .userSettingsArn("userSettingsArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.175Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnPortalProps")
@software.amazon.jsii.Jsii.Proxy(CfnPortalProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPortalProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The additional encryption context of the portal.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalEncryptionContext() {
        return null;
    }

    /**
     * The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code> .
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider (IdP). User and group access to your web portal is controlled through your IdP. You need to include an IdP resource in your template to integrate your IdP with your web portal. Completing the configuration for your IdP requires exchanging WorkSpaces Secure Browser’s SP metadata with your IdP’s IdP metadata. If your IdP requires the SP metadata first before returning the IdP metadata, you should follow these steps:
     * <p>
     * <ol>
     * <li>Create and deploy a CloudFormation template with a <code>Standard</code> portal with no <code>IdentityProvider</code> resource.</li>
     * <li>Retrieve the SP metadata using <code>Fn:GetAtt</code> , the WorkSpaces Secure Browser console, or by the calling the <code>GetPortalServiceProviderMetadata</code> API.</li>
     * <li>Submit the data to your IdP.</li>
     * <li>Add an <code>IdentityProvider</code> resource to your CloudFormation template.</li>
     * </ol>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through AWS IAM Identity Center . They provide additional features, such as IdP-initiated authentication. Identity sources (including external identity provider integration) and other identity provider information must be configured in IAM Identity Center . User and group assignment must be done through the WorkSpaces Secure Browser console. These cannot be configured in CloudFormation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-authenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
        return null;
    }

    /**
     * The ARN of the browser settings that is associated with this web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-browsersettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-browsersettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBrowserSettingsArn() {
        return null;
    }

    /**
     * The customer managed key of the web portal.
     * <p>
     * <em>Pattern</em> : <code>^arn:[\w+=\/,.&#64;-]+:kms:[a-zA-Z0-9\-]*:[a-zA-Z0-9]{1,12}:key\/[a-zA-Z0-9-]+$</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-customermanagedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-customermanagedkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerManagedKey() {
        return null;
    }

    /**
     * The ARN of the data protection settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-dataprotectionsettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-dataprotectionsettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataProtectionSettingsArn() {
        return null;
    }

    /**
     * The name of the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The type and resources of the underlying instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return null;
    }

    /**
     * The ARN of the IP access settings that is associated with the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-ipaccesssettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-ipaccesssettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAccessSettingsArn() {
        return null;
    }

    /**
     * The maximum number of concurrent sessions for the portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-maxconcurrentsessions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-maxconcurrentsessions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentSessions() {
        return null;
    }

    /**
     * The ARN of the network settings that is associated with the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-networksettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-networksettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkSettingsArn() {
        return null;
    }

    /**
     * The ARN of the session logger that is assocaited with the portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-sessionloggerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-sessionloggerarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionLoggerArn() {
        return null;
    }

    /**
     * The tags to add to the web portal.
     * <p>
     * A tag is a key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN of the trust store that is associated with the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-truststorearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-truststorearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrustStoreArn() {
        return null;
    }

    /**
     * The ARN of the user access logging settings that is associated with the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-useraccessloggingsettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-useraccessloggingsettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserAccessLoggingSettingsArn() {
        return null;
    }

    /**
     * The ARN of the user settings that is associated with the web portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-usersettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-usersettingsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserSettingsArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPortalProps> {
        java.lang.Object additionalEncryptionContext;
        java.lang.String authenticationType;
        java.lang.String browserSettingsArn;
        java.lang.String customerManagedKey;
        java.lang.String dataProtectionSettingsArn;
        java.lang.String displayName;
        java.lang.String instanceType;
        java.lang.String ipAccessSettingsArn;
        java.lang.Number maxConcurrentSessions;
        java.lang.String networkSettingsArn;
        java.lang.String sessionLoggerArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String trustStoreArn;
        java.lang.String userAccessLoggingSettingsArn;
        java.lang.String userSettingsArn;

        /**
         * Sets the value of {@link CfnPortalProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext The additional encryption context of the portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(java.util.Map<java.lang.String, java.lang.String> additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext The additional encryption context of the portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(software.amazon.awscdk.IResolvable additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getAuthenticationType}
         * @param authenticationType The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code> .
         *                           <code>Standard</code> web portals are authenticated directly through your identity provider (IdP). User and group access to your web portal is controlled through your IdP. You need to include an IdP resource in your template to integrate your IdP with your web portal. Completing the configuration for your IdP requires exchanging WorkSpaces Secure Browser’s SP metadata with your IdP’s IdP metadata. If your IdP requires the SP metadata first before returning the IdP metadata, you should follow these steps:
         *                           <p>
         *                           <ol>
         *                           <li>Create and deploy a CloudFormation template with a <code>Standard</code> portal with no <code>IdentityProvider</code> resource.</li>
         *                           <li>Retrieve the SP metadata using <code>Fn:GetAtt</code> , the WorkSpaces Secure Browser console, or by the calling the <code>GetPortalServiceProviderMetadata</code> API.</li>
         *                           <li>Submit the data to your IdP.</li>
         *                           <li>Add an <code>IdentityProvider</code> resource to your CloudFormation template.</li>
         *                           </ol>
         *                           <p>
         *                           <code>IAM Identity Center</code> web portals are authenticated through AWS IAM Identity Center . They provide additional features, such as IdP-initiated authentication. Identity sources (including external identity provider integration) and other identity provider information must be configured in IAM Identity Center . User and group assignment must be done through the WorkSpaces Secure Browser console. These cannot be configured in CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getBrowserSettingsArn}
         * @param browserSettingsArn The ARN of the browser settings that is associated with this web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserSettingsArn(java.lang.String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getCustomerManagedKey}
         * @param customerManagedKey The customer managed key of the web portal.
         *                           <em>Pattern</em> : <code>^arn:[\w+=\/,.&#64;-]+:kms:[a-zA-Z0-9\-]*:[a-zA-Z0-9]{1,12}:key\/[a-zA-Z0-9-]+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedKey(java.lang.String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getDataProtectionSettingsArn}
         * @param dataProtectionSettingsArn The ARN of the data protection settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionSettingsArn(java.lang.String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getDisplayName}
         * @param displayName The name of the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getInstanceType}
         * @param instanceType The type and resources of the underlying instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getIpAccessSettingsArn}
         * @param ipAccessSettingsArn The ARN of the IP access settings that is associated with the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAccessSettingsArn(java.lang.String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getMaxConcurrentSessions}
         * @param maxConcurrentSessions The maximum number of concurrent sessions for the portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrentSessions(java.lang.Number maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getNetworkSettingsArn}
         * @param networkSettingsArn The ARN of the network settings that is associated with the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkSettingsArn(java.lang.String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getSessionLoggerArn}
         * @param sessionLoggerArn The ARN of the session logger that is assocaited with the portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionLoggerArn(java.lang.String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getTags}
         * @param tags The tags to add to the web portal.
         *             A tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getTrustStoreArn}
         * @param trustStoreArn The ARN of the trust store that is associated with the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStoreArn(java.lang.String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getUserAccessLoggingSettingsArn}
         * @param userAccessLoggingSettingsArn The ARN of the user access logging settings that is associated with the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAccessLoggingSettingsArn(java.lang.String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPortalProps#getUserSettingsArn}
         * @param userSettingsArn The ARN of the user settings that is associated with the web portal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettingsArn(java.lang.String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPortalProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPortalProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPortalProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPortalProps {
        private final java.lang.Object additionalEncryptionContext;
        private final java.lang.String authenticationType;
        private final java.lang.String browserSettingsArn;
        private final java.lang.String customerManagedKey;
        private final java.lang.String dataProtectionSettingsArn;
        private final java.lang.String displayName;
        private final java.lang.String instanceType;
        private final java.lang.String ipAccessSettingsArn;
        private final java.lang.Number maxConcurrentSessions;
        private final java.lang.String networkSettingsArn;
        private final java.lang.String sessionLoggerArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String trustStoreArn;
        private final java.lang.String userAccessLoggingSettingsArn;
        private final java.lang.String userSettingsArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalEncryptionContext = software.amazon.jsii.Kernel.get(this, "additionalEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.browserSettingsArn = software.amazon.jsii.Kernel.get(this, "browserSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerManagedKey = software.amazon.jsii.Kernel.get(this, "customerManagedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataProtectionSettingsArn = software.amazon.jsii.Kernel.get(this, "dataProtectionSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAccessSettingsArn = software.amazon.jsii.Kernel.get(this, "ipAccessSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrentSessions = software.amazon.jsii.Kernel.get(this, "maxConcurrentSessions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.networkSettingsArn = software.amazon.jsii.Kernel.get(this, "networkSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionLoggerArn = software.amazon.jsii.Kernel.get(this, "sessionLoggerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trustStoreArn = software.amazon.jsii.Kernel.get(this, "trustStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userAccessLoggingSettingsArn = software.amazon.jsii.Kernel.get(this, "userAccessLoggingSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userSettingsArn = software.amazon.jsii.Kernel.get(this, "userSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalEncryptionContext = builder.additionalEncryptionContext;
            this.authenticationType = builder.authenticationType;
            this.browserSettingsArn = builder.browserSettingsArn;
            this.customerManagedKey = builder.customerManagedKey;
            this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
            this.displayName = builder.displayName;
            this.instanceType = builder.instanceType;
            this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
            this.maxConcurrentSessions = builder.maxConcurrentSessions;
            this.networkSettingsArn = builder.networkSettingsArn;
            this.sessionLoggerArn = builder.sessionLoggerArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trustStoreArn = builder.trustStoreArn;
            this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
            this.userSettingsArn = builder.userSettingsArn;
        }

        @Override
        public final java.lang.Object getAdditionalEncryptionContext() {
            return this.additionalEncryptionContext;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.String getBrowserSettingsArn() {
            return this.browserSettingsArn;
        }

        @Override
        public final java.lang.String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        @Override
        public final java.lang.String getDataProtectionSettingsArn() {
            return this.dataProtectionSettingsArn;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        @Override
        public final java.lang.Number getMaxConcurrentSessions() {
            return this.maxConcurrentSessions;
        }

        @Override
        public final java.lang.String getNetworkSettingsArn() {
            return this.networkSettingsArn;
        }

        @Override
        public final java.lang.String getSessionLoggerArn() {
            return this.sessionLoggerArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        @Override
        public final java.lang.String getUserAccessLoggingSettingsArn() {
            return this.userAccessLoggingSettingsArn;
        }

        @Override
        public final java.lang.String getUserSettingsArn() {
            return this.userSettingsArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalEncryptionContext() != null) {
                data.set("additionalEncryptionContext", om.valueToTree(this.getAdditionalEncryptionContext()));
            }
            if (this.getAuthenticationType() != null) {
                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            }
            if (this.getBrowserSettingsArn() != null) {
                data.set("browserSettingsArn", om.valueToTree(this.getBrowserSettingsArn()));
            }
            if (this.getCustomerManagedKey() != null) {
                data.set("customerManagedKey", om.valueToTree(this.getCustomerManagedKey()));
            }
            if (this.getDataProtectionSettingsArn() != null) {
                data.set("dataProtectionSettingsArn", om.valueToTree(this.getDataProtectionSettingsArn()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getIpAccessSettingsArn() != null) {
                data.set("ipAccessSettingsArn", om.valueToTree(this.getIpAccessSettingsArn()));
            }
            if (this.getMaxConcurrentSessions() != null) {
                data.set("maxConcurrentSessions", om.valueToTree(this.getMaxConcurrentSessions()));
            }
            if (this.getNetworkSettingsArn() != null) {
                data.set("networkSettingsArn", om.valueToTree(this.getNetworkSettingsArn()));
            }
            if (this.getSessionLoggerArn() != null) {
                data.set("sessionLoggerArn", om.valueToTree(this.getSessionLoggerArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrustStoreArn() != null) {
                data.set("trustStoreArn", om.valueToTree(this.getTrustStoreArn()));
            }
            if (this.getUserAccessLoggingSettingsArn() != null) {
                data.set("userAccessLoggingSettingsArn", om.valueToTree(this.getUserAccessLoggingSettingsArn()));
            }
            if (this.getUserSettingsArn() != null) {
                data.set("userSettingsArn", om.valueToTree(this.getUserSettingsArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnPortalProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPortalProps.Jsii$Proxy that = (CfnPortalProps.Jsii$Proxy) o;

            if (this.additionalEncryptionContext != null ? !this.additionalEncryptionContext.equals(that.additionalEncryptionContext) : that.additionalEncryptionContext != null) return false;
            if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
            if (this.browserSettingsArn != null ? !this.browserSettingsArn.equals(that.browserSettingsArn) : that.browserSettingsArn != null) return false;
            if (this.customerManagedKey != null ? !this.customerManagedKey.equals(that.customerManagedKey) : that.customerManagedKey != null) return false;
            if (this.dataProtectionSettingsArn != null ? !this.dataProtectionSettingsArn.equals(that.dataProtectionSettingsArn) : that.dataProtectionSettingsArn != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.ipAccessSettingsArn != null ? !this.ipAccessSettingsArn.equals(that.ipAccessSettingsArn) : that.ipAccessSettingsArn != null) return false;
            if (this.maxConcurrentSessions != null ? !this.maxConcurrentSessions.equals(that.maxConcurrentSessions) : that.maxConcurrentSessions != null) return false;
            if (this.networkSettingsArn != null ? !this.networkSettingsArn.equals(that.networkSettingsArn) : that.networkSettingsArn != null) return false;
            if (this.sessionLoggerArn != null ? !this.sessionLoggerArn.equals(that.sessionLoggerArn) : that.sessionLoggerArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.trustStoreArn != null ? !this.trustStoreArn.equals(that.trustStoreArn) : that.trustStoreArn != null) return false;
            if (this.userAccessLoggingSettingsArn != null ? !this.userAccessLoggingSettingsArn.equals(that.userAccessLoggingSettingsArn) : that.userAccessLoggingSettingsArn != null) return false;
            return this.userSettingsArn != null ? this.userSettingsArn.equals(that.userSettingsArn) : that.userSettingsArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalEncryptionContext != null ? this.additionalEncryptionContext.hashCode() : 0;
            result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
            result = 31 * result + (this.browserSettingsArn != null ? this.browserSettingsArn.hashCode() : 0);
            result = 31 * result + (this.customerManagedKey != null ? this.customerManagedKey.hashCode() : 0);
            result = 31 * result + (this.dataProtectionSettingsArn != null ? this.dataProtectionSettingsArn.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.ipAccessSettingsArn != null ? this.ipAccessSettingsArn.hashCode() : 0);
            result = 31 * result + (this.maxConcurrentSessions != null ? this.maxConcurrentSessions.hashCode() : 0);
            result = 31 * result + (this.networkSettingsArn != null ? this.networkSettingsArn.hashCode() : 0);
            result = 31 * result + (this.sessionLoggerArn != null ? this.sessionLoggerArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trustStoreArn != null ? this.trustStoreArn.hashCode() : 0);
            result = 31 * result + (this.userAccessLoggingSettingsArn != null ? this.userAccessLoggingSettingsArn.hashCode() : 0);
            result = 31 * result + (this.userSettingsArn != null ? this.userSettingsArn.hashCode() : 0);
            return result;
        }
    }
}
