package software.amazon.awscdk.services.workspacesweb;

/**
 * A reference to a NetworkSettings resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * NetworkSettingsReference networkSettingsReference = NetworkSettingsReference.builder()
 *         .networkSettingsArn("networkSettingsArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.204Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.NetworkSettingsReference")
@software.amazon.jsii.Jsii.Proxy(NetworkSettingsReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkSettingsReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The NetworkSettingsArn of the NetworkSettings resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkSettingsArn();

    /**
     * @return a {@link Builder} of {@link NetworkSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkSettingsReference> {
        java.lang.String networkSettingsArn;

        /**
         * Sets the value of {@link NetworkSettingsReference#getNetworkSettingsArn}
         * @param networkSettingsArn The NetworkSettingsArn of the NetworkSettings resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkSettingsArn(java.lang.String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkSettingsReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkSettingsReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkSettingsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkSettingsReference {
        private final java.lang.String networkSettingsArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkSettingsArn = software.amazon.jsii.Kernel.get(this, "networkSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkSettingsArn = java.util.Objects.requireNonNull(builder.networkSettingsArn, "networkSettingsArn is required");
        }

        @Override
        public final java.lang.String getNetworkSettingsArn() {
            return this.networkSettingsArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkSettingsArn", om.valueToTree(this.getNetworkSettingsArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.NetworkSettingsReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkSettingsReference.Jsii$Proxy that = (NetworkSettingsReference.Jsii$Proxy) o;

            return this.networkSettingsArn.equals(that.networkSettingsArn);
        }

        @Override
        public final int hashCode() {
            int result = this.networkSettingsArn.hashCode();
            return result;
        }
    }
}
