package software.amazon.awscdk;

/**
 * Construction properties of <code>BootstraplessSynthesizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * BootstraplessSynthesizerProps bootstraplessSynthesizerProps = BootstraplessSynthesizerProps.builder()
 *         .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *         .deployRoleArn("deployRoleArn")
 *         .qualifier("qualifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:43.689Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.BootstraplessSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(BootstraplessSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BootstraplessSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CFN execution Role ARN to use.
     * <p>
     * Default: - No CloudFormation role (use CLI credentials)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return null;
    }

    /**
     * The deploy Role ARN to use.
     * <p>
     * Default: - No deploy role (use CLI credentials)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleArn() {
        return null;
    }

    /**
     * The qualifier used to specialize strings.
     * <p>
     * Can be used to specify custom bootstrapped role names
     * <p>
     * Default: 'hnb659fds'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BootstraplessSynthesizerProps> {
        java.lang.String cloudFormationExecutionRoleArn;
        java.lang.String deployRoleArn;
        java.lang.String qualifier;

        /**
         * Sets the value of {@link BootstraplessSynthesizerProps#getCloudFormationExecutionRoleArn}
         * @param cloudFormationExecutionRoleArn The CFN execution Role ARN to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(java.lang.String cloudFormationExecutionRoleArn) {
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link BootstraplessSynthesizerProps#getDeployRoleArn}
         * @param deployRoleArn The deploy Role ARN to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(java.lang.String deployRoleArn) {
            this.deployRoleArn = deployRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link BootstraplessSynthesizerProps#getQualifier}
         * @param qualifier The qualifier used to specialize strings.
         *                  Can be used to specify custom bootstrapped role names
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BootstraplessSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BootstraplessSynthesizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BootstraplessSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstraplessSynthesizerProps {
        private final java.lang.String cloudFormationExecutionRoleArn;
        private final java.lang.String deployRoleArn;
        private final java.lang.String qualifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudFormationExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleArn = software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudFormationExecutionRoleArn = builder.cloudFormationExecutionRoleArn;
            this.deployRoleArn = builder.deployRoleArn;
            this.qualifier = builder.qualifier;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRoleArn() {
            return this.cloudFormationExecutionRoleArn;
        }

        @Override
        public final java.lang.String getDeployRoleArn() {
            return this.deployRoleArn;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudFormationExecutionRoleArn() != null) {
                data.set("cloudFormationExecutionRoleArn", om.valueToTree(this.getCloudFormationExecutionRoleArn()));
            }
            if (this.getDeployRoleArn() != null) {
                data.set("deployRoleArn", om.valueToTree(this.getDeployRoleArn()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.BootstraplessSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BootstraplessSynthesizerProps.Jsii$Proxy that = (BootstraplessSynthesizerProps.Jsii$Proxy) o;

            if (this.cloudFormationExecutionRoleArn != null ? !this.cloudFormationExecutionRoleArn.equals(that.cloudFormationExecutionRoleArn) : that.cloudFormationExecutionRoleArn != null) return false;
            if (this.deployRoleArn != null ? !this.deployRoleArn.equals(that.deployRoleArn) : that.deployRoleArn != null) return false;
            return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudFormationExecutionRoleArn != null ? this.cloudFormationExecutionRoleArn.hashCode() : 0;
            result = 31 * result + (this.deployRoleArn != null ? this.deployRoleArn.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }
    }
}
