package software.amazon.awscdk;

/**
 * Type of the <code>CfnCodeDeployBlueGreenEcsAttributes.trafficRouting</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnTrafficRouting cfnTrafficRouting = CfnTrafficRouting.builder()
 *         .prodTrafficRoute(CfnTrafficRoute.builder()
 *                 .logicalId("logicalId")
 *                 .type("type")
 *                 .build())
 *         .targetGroups(List.of("targetGroups"))
 *         .testTrafficRoute(CfnTrafficRoute.builder()
 *                 .logicalId("logicalId")
 *                 .type("type")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:43.795Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnTrafficRouting")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficRouting.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficRouting extends software.amazon.jsii.JsiiSerializable {

    /**
     * The listener to be used by your load balancer to direct traffic to your target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnTrafficRoute getProdTrafficRoute();

    /**
     * The logical IDs of the blue and green, respectively, AWS::ElasticLoadBalancingV2::TargetGroup target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetGroups();

    /**
     * The listener to be used by your load balancer to direct traffic to your target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnTrafficRoute getTestTrafficRoute();

    /**
     * @return a {@link Builder} of {@link CfnTrafficRouting}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficRouting}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficRouting> {
        software.amazon.awscdk.CfnTrafficRoute prodTrafficRoute;
        java.util.List<java.lang.String> targetGroups;
        software.amazon.awscdk.CfnTrafficRoute testTrafficRoute;

        /**
         * Sets the value of {@link CfnTrafficRouting#getProdTrafficRoute}
         * @param prodTrafficRoute The listener to be used by your load balancer to direct traffic to your target groups. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prodTrafficRoute(software.amazon.awscdk.CfnTrafficRoute prodTrafficRoute) {
            this.prodTrafficRoute = prodTrafficRoute;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRouting#getTargetGroups}
         * @param targetGroups The logical IDs of the blue and green, respectively, AWS::ElasticLoadBalancingV2::TargetGroup target groups. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<java.lang.String> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficRouting#getTestTrafficRoute}
         * @param testTrafficRoute The listener to be used by your load balancer to direct traffic to your target groups. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testTrafficRoute(software.amazon.awscdk.CfnTrafficRoute testTrafficRoute) {
            this.testTrafficRoute = testTrafficRoute;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficRouting}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficRouting build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrafficRouting}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficRouting {
        private final software.amazon.awscdk.CfnTrafficRoute prodTrafficRoute;
        private final java.util.List<java.lang.String> targetGroups;
        private final software.amazon.awscdk.CfnTrafficRoute testTrafficRoute;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prodTrafficRoute = software.amazon.jsii.Kernel.get(this, "prodTrafficRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTrafficRoute.class));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.testTrafficRoute = software.amazon.jsii.Kernel.get(this, "testTrafficRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTrafficRoute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prodTrafficRoute = java.util.Objects.requireNonNull(builder.prodTrafficRoute, "prodTrafficRoute is required");
            this.targetGroups = java.util.Objects.requireNonNull(builder.targetGroups, "targetGroups is required");
            this.testTrafficRoute = java.util.Objects.requireNonNull(builder.testTrafficRoute, "testTrafficRoute is required");
        }

        @Override
        public final software.amazon.awscdk.CfnTrafficRoute getProdTrafficRoute() {
            return this.prodTrafficRoute;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public final software.amazon.awscdk.CfnTrafficRoute getTestTrafficRoute() {
            return this.testTrafficRoute;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("prodTrafficRoute", om.valueToTree(this.getProdTrafficRoute()));
            data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            data.set("testTrafficRoute", om.valueToTree(this.getTestTrafficRoute()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnTrafficRouting"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficRouting.Jsii$Proxy that = (CfnTrafficRouting.Jsii$Proxy) o;

            if (!prodTrafficRoute.equals(that.prodTrafficRoute)) return false;
            if (!targetGroups.equals(that.targetGroups)) return false;
            return this.testTrafficRoute.equals(that.testTrafficRoute);
        }

        @Override
        public final int hashCode() {
            int result = this.prodTrafficRoute.hashCode();
            result = 31 * result + (this.targetGroups.hashCode());
            result = 31 * result + (this.testTrafficRoute.hashCode());
            return result;
        }
    }
}
