package software.amazon.awscdk;

/**
 * Initialization options for custom resource providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object policyStatements;
 * Size size;
 * CustomResourceProviderOptions customResourceProviderOptions = CustomResourceProviderOptions.builder()
 *         .description("description")
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .memorySize(size)
 *         .policyStatements(List.of(policyStatements))
 *         .timeout(Duration.minutes(30))
 *         .useCfnResponseWrapper(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:43.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResourceProviderOptions")
@software.amazon.jsii.Jsii.Proxy(CustomResourceProviderOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomResourceProviderOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the function.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Key-value pairs that are passed to Lambda as Environment.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The amount of memory that your function has access to.
     * <p>
     * Increasing the
     * function's memory also increases its CPU allocation.
     * <p>
     * Default: Size.mebibytes(128)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMemorySize() {
        return null;
    }

    /**
     * A set of IAM policy statements to include in the inline policy of the provider's lambda function.
     * <p>
     * <strong>Please note</strong>: these are direct IAM JSON policy blobs, <em>not</em> <code>iam.PolicyStatement</code>
     * objects like you will see in the rest of the CDK.
     * <p>
     * Default: - no additional inline policy
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * CustomResourceProvider provider = CustomResourceProvider.getOrCreateProvider(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
     *         .codeDirectory(String.format("%s/my-handler", __dirname))
     *         .runtime(CustomResourceProviderRuntime.NODEJS_18_X)
     *         .policyStatements(List.of(Map.of(
     *                 "Effect", "Allow",
     *                 "Action", "s3:PutObject*",
     *                 "Resource", "*")))
     *         .build());
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getPolicyStatements() {
        return null;
    }

    /**
     * AWS Lambda timeout for the provider.
     * <p>
     * Default: Duration.minutes(15)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * Whether or not the cloudformation response wrapper (<code>nodejs-entrypoint.ts</code>) is used. If set to <code>true</code>, <code>nodejs-entrypoint.js</code> is bundled in the same asset as the custom resource and set as the entrypoint. If set to <code>false</code>, the custom resource provided is the entrypoint.
     * <p>
     * Default: - `true` if `inlineCode: false` and `false` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseCfnResponseWrapper() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomResourceProviderOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomResourceProviderOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomResourceProviderOptions> {
        java.lang.String description;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.Size memorySize;
        java.util.List<java.lang.Object> policyStatements;
        software.amazon.awscdk.Duration timeout;
        java.lang.Boolean useCfnResponseWrapper;

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getEnvironment}
         * @param environment Key-value pairs that are passed to Lambda as Environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getMemorySize}
         * @param memorySize The amount of memory that your function has access to.
         *                   Increasing the
         *                   function's memory also increases its CPU allocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(software.amazon.awscdk.Size memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getPolicyStatements}
         * @param policyStatements A set of IAM policy statements to include in the inline policy of the provider's lambda function.
         *                         <strong>Please note</strong>: these are direct IAM JSON policy blobs, <em>not</em> <code>iam.PolicyStatement</code>
         *                         objects like you will see in the rest of the CDK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policyStatements(java.util.List<? extends java.lang.Object> policyStatements) {
            this.policyStatements = (java.util.List<java.lang.Object>)policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getTimeout}
         * @param timeout AWS Lambda timeout for the provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CustomResourceProviderOptions#getUseCfnResponseWrapper}
         * @param useCfnResponseWrapper Whether or not the cloudformation response wrapper (<code>nodejs-entrypoint.ts</code>) is used. If set to <code>true</code>, <code>nodejs-entrypoint.js</code> is bundled in the same asset as the custom resource and set as the entrypoint. If set to <code>false</code>, the custom resource provided is the entrypoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCfnResponseWrapper(java.lang.Boolean useCfnResponseWrapper) {
            this.useCfnResponseWrapper = useCfnResponseWrapper;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomResourceProviderOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomResourceProviderOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomResourceProviderOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResourceProviderOptions {
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.Size memorySize;
        private final java.util.List<java.lang.Object> policyStatements;
        private final software.amazon.awscdk.Duration timeout;
        private final java.lang.Boolean useCfnResponseWrapper;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.policyStatements = software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.useCfnResponseWrapper = software.amazon.jsii.Kernel.get(this, "useCfnResponseWrapper", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.environment = builder.environment;
            this.memorySize = builder.memorySize;
            this.policyStatements = (java.util.List<java.lang.Object>)builder.policyStatements;
            this.timeout = builder.timeout;
            this.useCfnResponseWrapper = builder.useCfnResponseWrapper;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.Size getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final java.util.List<java.lang.Object> getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Boolean getUseCfnResponseWrapper() {
            return this.useCfnResponseWrapper;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getPolicyStatements() != null) {
                data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUseCfnResponseWrapper() != null) {
                data.set("useCfnResponseWrapper", om.valueToTree(this.getUseCfnResponseWrapper()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CustomResourceProviderOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomResourceProviderOptions.Jsii$Proxy that = (CustomResourceProviderOptions.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.policyStatements != null ? !this.policyStatements.equals(that.policyStatements) : that.policyStatements != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.useCfnResponseWrapper != null ? this.useCfnResponseWrapper.equals(that.useCfnResponseWrapper) : that.useCfnResponseWrapper == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.policyStatements != null ? this.policyStatements.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.useCfnResponseWrapper != null ? this.useCfnResponseWrapper.hashCode() : 0);
            return result;
        }
    }
}
