package software.amazon.awscdk;

/**
 * Manages removal policies for resources without existing policies within a construct scope.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * MissingRemovalPolicies missingRemovalPolicies = MissingRemovalPolicies.of(this);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:43.896Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.MissingRemovalPolicies")
public class MissingRemovalPolicies extends software.amazon.jsii.JsiiObject {

    protected MissingRemovalPolicies(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MissingRemovalPolicies(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the missing removal policies API for the given scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.MissingRemovalPolicies of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.MissingRemovalPolicies.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.MissingRemovalPolicies.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Apply a removal policy only to resources without existing policies within this scope.
     * <p>
     * @param policy The removal policy to apply. This parameter is required.
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void apply(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "apply", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required"), props });
    }

    /**
     * Apply a removal policy only to resources without existing policies within this scope.
     * <p>
     * @param policy The removal policy to apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void apply(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "apply", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Apply DESTROY removal policy only to resources without existing policies within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void destroy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "destroy", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply DESTROY removal policy only to resources without existing policies within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void destroy() {
        software.amazon.jsii.Kernel.call(this, "destroy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply RETAIN removal policy only to resources without existing policies within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retain(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "retain", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply RETAIN removal policy only to resources without existing policies within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retain() {
        software.amazon.jsii.Kernel.call(this, "retain", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply RETAIN_ON_UPDATE_OR_DELETE removal policy only to resources without existing policies within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retainOnUpdateOrDelete(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "retainOnUpdateOrDelete", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply RETAIN_ON_UPDATE_OR_DELETE removal policy only to resources without existing policies within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retainOnUpdateOrDelete() {
        software.amazon.jsii.Kernel.call(this, "retainOnUpdateOrDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply SNAPSHOT removal policy only to resources without existing policies within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void snapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "snapshot", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply SNAPSHOT removal policy only to resources without existing policies within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void snapshot() {
        software.amazon.jsii.Kernel.call(this, "snapshot", software.amazon.jsii.NativeType.VOID);
    }
}
