package software.amazon.awscdk;

/**
 * Options for creating a unique resource name.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * UniqueResourceNameOptions uniqueResourceNameOptions = UniqueResourceNameOptions.builder()
 *         .allowedSpecialCharacters("allowedSpecialCharacters")
 *         .maxLength(123)
 *         .separator("separator")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:40:43.969Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.UniqueResourceNameOptions")
@software.amazon.jsii.Jsii.Proxy(UniqueResourceNameOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UniqueResourceNameOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Non-alphanumeric characters allowed in the unique resource name.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllowedSpecialCharacters() {
        return null;
    }

    /**
     * The maximum length of the unique resource name.
     * <p>
     * Default: - 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLength() {
        return null;
    }

    /**
     * The separator used between the path components.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSeparator() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UniqueResourceNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UniqueResourceNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UniqueResourceNameOptions> {
        java.lang.String allowedSpecialCharacters;
        java.lang.Number maxLength;
        java.lang.String separator;

        /**
         * Sets the value of {@link UniqueResourceNameOptions#getAllowedSpecialCharacters}
         * @param allowedSpecialCharacters Non-alphanumeric characters allowed in the unique resource name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedSpecialCharacters(java.lang.String allowedSpecialCharacters) {
            this.allowedSpecialCharacters = allowedSpecialCharacters;
            return this;
        }

        /**
         * Sets the value of {@link UniqueResourceNameOptions#getMaxLength}
         * @param maxLength The maximum length of the unique resource name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLength(java.lang.Number maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        /**
         * Sets the value of {@link UniqueResourceNameOptions#getSeparator}
         * @param separator The separator used between the path components.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder separator(java.lang.String separator) {
            this.separator = separator;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UniqueResourceNameOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UniqueResourceNameOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UniqueResourceNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UniqueResourceNameOptions {
        private final java.lang.String allowedSpecialCharacters;
        private final java.lang.Number maxLength;
        private final java.lang.String separator;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedSpecialCharacters = software.amazon.jsii.Kernel.get(this, "allowedSpecialCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxLength = software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.separator = software.amazon.jsii.Kernel.get(this, "separator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedSpecialCharacters = builder.allowedSpecialCharacters;
            this.maxLength = builder.maxLength;
            this.separator = builder.separator;
        }

        @Override
        public final java.lang.String getAllowedSpecialCharacters() {
            return this.allowedSpecialCharacters;
        }

        @Override
        public final java.lang.Number getMaxLength() {
            return this.maxLength;
        }

        @Override
        public final java.lang.String getSeparator() {
            return this.separator;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedSpecialCharacters() != null) {
                data.set("allowedSpecialCharacters", om.valueToTree(this.getAllowedSpecialCharacters()));
            }
            if (this.getMaxLength() != null) {
                data.set("maxLength", om.valueToTree(this.getMaxLength()));
            }
            if (this.getSeparator() != null) {
                data.set("separator", om.valueToTree(this.getSeparator()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.UniqueResourceNameOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UniqueResourceNameOptions.Jsii$Proxy that = (UniqueResourceNameOptions.Jsii$Proxy) o;

            if (this.allowedSpecialCharacters != null ? !this.allowedSpecialCharacters.equals(that.allowedSpecialCharacters) : that.allowedSpecialCharacters != null) return false;
            if (this.maxLength != null ? !this.maxLength.equals(that.maxLength) : that.maxLength != null) return false;
            return this.separator != null ? this.separator.equals(that.separator) : that.separator == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedSpecialCharacters != null ? this.allowedSpecialCharacters.hashCode() : 0;
            result = 31 * result + (this.maxLength != null ? this.maxLength.hashCode() : 0);
            result = 31 * result + (this.separator != null ? this.separator.hashCode() : 0);
            return result;
        }
    }
}
