package software.amazon.awscdk.customresources;

/**
 * An AWS SDK call.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource.Builder.create(this, "GetParameterCustomResource")
 *         .onUpdate(AwsSdkCall.builder() // will also be called for a CREATE event
 *                 .service("SSM")
 *                 .action("getParameter")
 *                 .parameters(Map.of(
 *                         "Name", "my-parameter",
 *                         "WithDecryption", true))
 *                 .physicalResourceId(PhysicalResourceId.fromResponse("Parameter.ARN")).build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.825Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.AwsSdkCall")
@software.amazon.jsii.Jsii.Proxy(AwsSdkCall.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsSdkCall extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service action to call.
     * <p>
     * This is the name of an AWS API call, in one of the following forms:
     * <p>
     * <ul>
     * <li>An API call name as found in the API Reference documentation (<code>GetObject</code>)</li>
     * <li>The API call name starting with a lowercase letter (<code>getObject</code>)</li>
     * <li>The AWS SDK for JavaScript v3 command class name (<code>GetObjectCommand</code>)</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The service to call.
     * <p>
     * This is the name of an AWS service, in one of the following forms:
     * <p>
     * <ul>
     * <li>An AWS SDK for JavaScript v3 package name (<code>&#64;aws-sdk/client-api-gateway</code>)</li>
     * <li>An AWS SDK for JavaScript v3 client name (<code>api-gateway</code>)</li>
     * <li>An AWS SDK for JavaScript v2 constructor name (<code>APIGateway</code>)</li>
     * <li>A lowercase AWS SDK for JavaScript v2 constructor name (<code>apigateway</code>)</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * API version to use for the service.
     * <p>
     * Default: - use latest available API version
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html">https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
        return null;
    }

    /**
     * Used for running the SDK calls in underlying lambda with a different role.
     * <p>
     * Can be used primarily for cross-account requests to for example connect
     * hostedzone with a shared vpc.
     * Region controls where assumeRole call is made.
     * <p>
     * Example for Route53 / associateVPCWithHostedZone
     * <p>
     * Default: - run without assuming role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumedRoleArn() {
        return null;
    }

    /**
     * External ID to use when assuming the role for cross-account requests.
     * <p>
     * This is an additional security measure that helps prevent the "confused deputy"
     * problem where an entity that doesn't have permission to perform an action
     * can coerce a more-privileged entity to perform the action.
     * <p>
     * The external ID must be provided by the third-party service and should not
     * be generated by you. This value should be unique among the third-party
     * service's customers.
     * <p>
     * This property is only used when <code>assumedRoleArn</code> is specified.
     * <p>
     * Default: - no external ID
     * <p>
     * @see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
        return null;
    }

    /**
     * The regex pattern to use to catch API errors.
     * <p>
     * The <code>code</code> property of the
     * <code>Error</code> object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     * <p>
     * Default: - do not catch errors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIgnoreErrorCodesMatching() {
        return null;
    }

    /**
     * A property used to configure logging during lambda function execution.
     * <p>
     * Note: The default Logging configuration is all. This configuration will enable logging on all logged data
     * in the lambda handler. This includes:
     * <p>
     * <ul>
     * <li>The event object that is received by the lambda handler</li>
     * <li>The response received after making a API call</li>
     * <li>The response object that the lambda handler will return</li>
     * <li>SDK versioning information</li>
     * <li>Caught and uncaught errors</li>
     * </ul>
     * <p>
     * Default: Logging.all()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.Logging getLogging() {
        return null;
    }

    /**
     * Restrict the data returned by the custom resource to specific paths in the API response.
     * <p>
     * Use this to limit the data returned by the custom
     * resource if working with API calls that could potentially result in custom
     * response objects exceeding the hard limit of 4096 bytes.
     * <p>
     * Example for ECS / updateService: ['service.deploymentConfiguration.maximumPercent']
     * <p>
     * Default: - return all data
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputPaths() {
        return null;
    }

    /**
     * The parameters for the service action.
     * <p>
     * Default: - no parameters
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * The physical resource id of the custom resource for this call.
     * <p>
     * Mandatory for onCreate call.
     * In onUpdate, you can omit this to passthrough it from request.
     * <p>
     * Default: - no physical resource id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.PhysicalResourceId getPhysicalResourceId() {
        return null;
    }

    /**
     * The region to send service requests to.
     * <p>
     * <strong>Note: Cross-region operations are generally considered an anti-pattern.</strong>
     * <strong>Consider first deploying a stack in that region.</strong>
     * <p>
     * Default: - the region where this custom resource is deployed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsSdkCall> {
        java.lang.String action;
        java.lang.String service;
        java.lang.String apiVersion;
        java.lang.String assumedRoleArn;
        java.lang.String externalId;
        java.lang.String ignoreErrorCodesMatching;
        software.amazon.awscdk.customresources.Logging logging;
        java.util.List<java.lang.String> outputPaths;
        java.lang.Object parameters;
        software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId;
        java.lang.String region;

        /**
         * Sets the value of {@link AwsSdkCall#getAction}
         * @param action The service action to call. This parameter is required.
         *               This is the name of an AWS API call, in one of the following forms:
         *               <p>
         *               <ul>
         *               <li>An API call name as found in the API Reference documentation (<code>GetObject</code>)</li>
         *               <li>The API call name starting with a lowercase letter (<code>getObject</code>)</li>
         *               <li>The AWS SDK for JavaScript v3 command class name (<code>GetObjectCommand</code>)</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getService}
         * @param service The service to call. This parameter is required.
         *                This is the name of an AWS service, in one of the following forms:
         *                <p>
         *                <ul>
         *                <li>An AWS SDK for JavaScript v3 package name (<code>&#64;aws-sdk/client-api-gateway</code>)</li>
         *                <li>An AWS SDK for JavaScript v3 client name (<code>api-gateway</code>)</li>
         *                <li>An AWS SDK for JavaScript v2 constructor name (<code>APIGateway</code>)</li>
         *                <li>A lowercase AWS SDK for JavaScript v2 constructor name (<code>apigateway</code>)</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getApiVersion}
         * @param apiVersion API version to use for the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiVersion(java.lang.String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getAssumedRoleArn}
         * @param assumedRoleArn Used for running the SDK calls in underlying lambda with a different role.
         *                       Can be used primarily for cross-account requests to for example connect
         *                       hostedzone with a shared vpc.
         *                       Region controls where assumeRole call is made.
         *                       <p>
         *                       Example for Route53 / associateVPCWithHostedZone
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumedRoleArn(java.lang.String assumedRoleArn) {
            this.assumedRoleArn = assumedRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getExternalId}
         * @param externalId External ID to use when assuming the role for cross-account requests.
         *                   This is an additional security measure that helps prevent the "confused deputy"
         *                   problem where an entity that doesn't have permission to perform an action
         *                   can coerce a more-privileged entity to perform the action.
         *                   <p>
         *                   The external ID must be provided by the third-party service and should not
         *                   be generated by you. This value should be unique among the third-party
         *                   service's customers.
         *                   <p>
         *                   This property is only used when <code>assumedRoleArn</code> is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalId(java.lang.String externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getIgnoreErrorCodesMatching}
         * @param ignoreErrorCodesMatching The regex pattern to use to catch API errors.
         *                                 The <code>code</code> property of the
         *                                 <code>Error</code> object will be tested against this pattern. If there is a match an
         *                                 error will not be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrorCodesMatching(java.lang.String ignoreErrorCodesMatching) {
            this.ignoreErrorCodesMatching = ignoreErrorCodesMatching;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getLogging}
         * @param logging A property used to configure logging during lambda function execution.
         *                Note: The default Logging configuration is all. This configuration will enable logging on all logged data
         *                in the lambda handler. This includes:
         *                <p>
         *                <ul>
         *                <li>The event object that is received by the lambda handler</li>
         *                <li>The response received after making a API call</li>
         *                <li>The response object that the lambda handler will return</li>
         *                <li>SDK versioning information</li>
         *                <li>Caught and uncaught errors</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.customresources.Logging logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getOutputPaths}
         * @param outputPaths Restrict the data returned by the custom resource to specific paths in the API response.
         *                    Use this to limit the data returned by the custom
         *                    resource if working with API calls that could potentially result in custom
         *                    response objects exceeding the hard limit of 4096 bytes.
         *                    <p>
         *                    Example for ECS / updateService: ['service.deploymentConfiguration.maximumPercent']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPaths(java.util.List<java.lang.String> outputPaths) {
            this.outputPaths = outputPaths;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getParameters}
         * @param parameters The parameters for the service action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getPhysicalResourceId}
         * @param physicalResourceId The physical resource id of the custom resource for this call.
         *                           Mandatory for onCreate call.
         *                           In onUpdate, you can omit this to passthrough it from request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalResourceId(software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        /**
         * Sets the value of {@link AwsSdkCall#getRegion}
         * @param region The region to send service requests to.
         *               <strong>Note: Cross-region operations are generally considered an anti-pattern.</strong>
         *               <strong>Consider first deploying a stack in that region.</strong>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsSdkCall}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsSdkCall build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsSdkCall {
        private final java.lang.String action;
        private final java.lang.String service;
        private final java.lang.String apiVersion;
        private final java.lang.String assumedRoleArn;
        private final java.lang.String externalId;
        private final java.lang.String ignoreErrorCodesMatching;
        private final software.amazon.awscdk.customresources.Logging logging;
        private final java.util.List<java.lang.String> outputPaths;
        private final java.lang.Object parameters;
        private final software.amazon.awscdk.customresources.PhysicalResourceId physicalResourceId;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumedRoleArn = software.amazon.jsii.Kernel.get(this, "assumedRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreErrorCodesMatching = software.amazon.jsii.Kernel.get(this, "ignoreErrorCodesMatching", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.Logging.class));
            this.outputPaths = software.amazon.jsii.Kernel.get(this, "outputPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.physicalResourceId = software.amazon.jsii.Kernel.get(this, "physicalResourceId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.PhysicalResourceId.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.apiVersion = builder.apiVersion;
            this.assumedRoleArn = builder.assumedRoleArn;
            this.externalId = builder.externalId;
            this.ignoreErrorCodesMatching = builder.ignoreErrorCodesMatching;
            this.logging = builder.logging;
            this.outputPaths = builder.outputPaths;
            this.parameters = builder.parameters;
            this.physicalResourceId = builder.physicalResourceId;
            this.region = builder.region;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.lang.String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        public final java.lang.String getAssumedRoleArn() {
            return this.assumedRoleArn;
        }

        @Override
        public final java.lang.String getExternalId() {
            return this.externalId;
        }

        @Override
        public final java.lang.String getIgnoreErrorCodesMatching() {
            return this.ignoreErrorCodesMatching;
        }

        @Override
        public final software.amazon.awscdk.customresources.Logging getLogging() {
            return this.logging;
        }

        @Override
        public final java.util.List<java.lang.String> getOutputPaths() {
            return this.outputPaths;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.customresources.PhysicalResourceId getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getApiVersion() != null) {
                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
            }
            if (this.getAssumedRoleArn() != null) {
                data.set("assumedRoleArn", om.valueToTree(this.getAssumedRoleArn()));
            }
            if (this.getExternalId() != null) {
                data.set("externalId", om.valueToTree(this.getExternalId()));
            }
            if (this.getIgnoreErrorCodesMatching() != null) {
                data.set("ignoreErrorCodesMatching", om.valueToTree(this.getIgnoreErrorCodesMatching()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getOutputPaths() != null) {
                data.set("outputPaths", om.valueToTree(this.getOutputPaths()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPhysicalResourceId() != null) {
                data.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.AwsSdkCall"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsSdkCall.Jsii$Proxy that = (AwsSdkCall.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!service.equals(that.service)) return false;
            if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
            if (this.assumedRoleArn != null ? !this.assumedRoleArn.equals(that.assumedRoleArn) : that.assumedRoleArn != null) return false;
            if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
            if (this.ignoreErrorCodesMatching != null ? !this.ignoreErrorCodesMatching.equals(that.ignoreErrorCodesMatching) : that.ignoreErrorCodesMatching != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.outputPaths != null ? !this.outputPaths.equals(that.outputPaths) : that.outputPaths != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.physicalResourceId != null ? !this.physicalResourceId.equals(that.physicalResourceId) : that.physicalResourceId != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
            result = 31 * result + (this.assumedRoleArn != null ? this.assumedRoleArn.hashCode() : 0);
            result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
            result = 31 * result + (this.ignoreErrorCodesMatching != null ? this.ignoreErrorCodesMatching.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.outputPaths != null ? this.outputPaths.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.physicalResourceId != null ? this.physicalResourceId.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
