package software.amazon.awscdk.interfaces;

/**
 * Used to indicate that a particular construct has an resource environment.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.IEnvironmentAware")
@software.amazon.jsii.Jsii.Proxy(IEnvironmentAware.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEnvironmentAware extends software.amazon.jsii.JsiiSerializable {

    /**
     * The environment this resource belongs to.
     * <p>
     * For resources that are created and managed in a Stack (those created by
     * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
     * is always the same as the environment of the stack they belong to.
     * <p>
     * For referenced resources (those obtained from referencing methods like
     * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
     * different than the stack they were imported into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.interfaces.IEnvironmentAware.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }
    }

    /**
     * Internal default implementation for {@link IEnvironmentAware}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEnvironmentAware {

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed in a Stack (those created by
         * creating new class instances like <code>new Role()</code>, <code>new Bucket()</code>, etc.), this
         * is always the same as the environment of the stack they belong to.
         * <p>
         * For referenced resources (those obtained from referencing methods like
         * <code>Role.fromRoleArn()</code>, <code>Bucket.fromBucketName()</code>, etc.), they might be
         * different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ResourceEnvironment.class));
        }
    }
}
