package software.amazon.awscdk.interfaces.amplifyuibuilder;

/**
 * A reference to a Component resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.amplifyuibuilder.*;
 * ComponentReference componentReference = ComponentReference.builder()
 *         .appId("appId")
 *         .componentId("componentId")
 *         .environmentName("environmentName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.877Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_amplifyuibuilder.ComponentReference")
@software.amazon.jsii.Jsii.Proxy(ComponentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ComponentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AppId of the Component resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppId();

    /**
     * The Id of the Component resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComponentId();

    /**
     * The EnvironmentName of the Component resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentName();

    /**
     * @return a {@link Builder} of {@link ComponentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComponentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ComponentReference> {
        java.lang.String appId;
        java.lang.String componentId;
        java.lang.String environmentName;

        /**
         * Sets the value of {@link ComponentReference#getAppId}
         * @param appId The AppId of the Component resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link ComponentReference#getComponentId}
         * @param componentId The Id of the Component resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentId(java.lang.String componentId) {
            this.componentId = componentId;
            return this;
        }

        /**
         * Sets the value of {@link ComponentReference#getEnvironmentName}
         * @param environmentName The EnvironmentName of the Component resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComponentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ComponentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComponentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentReference {
        private final java.lang.String appId;
        private final java.lang.String componentId;
        private final java.lang.String environmentName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.componentId = software.amazon.jsii.Kernel.get(this, "componentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = java.util.Objects.requireNonNull(builder.appId, "appId is required");
            this.componentId = java.util.Objects.requireNonNull(builder.componentId, "componentId is required");
            this.environmentName = java.util.Objects.requireNonNull(builder.environmentName, "environmentName is required");
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.String getComponentId() {
            return this.componentId;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appId", om.valueToTree(this.getAppId()));
            data.set("componentId", om.valueToTree(this.getComponentId()));
            data.set("environmentName", om.valueToTree(this.getEnvironmentName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_amplifyuibuilder.ComponentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComponentReference.Jsii$Proxy that = (ComponentReference.Jsii$Proxy) o;

            if (!appId.equals(that.appId)) return false;
            if (!componentId.equals(that.componentId)) return false;
            return this.environmentName.equals(that.environmentName);
        }

        @Override
        public final int hashCode() {
            int result = this.appId.hashCode();
            result = 31 * result + (this.componentId.hashCode());
            result = 31 * result + (this.environmentName.hashCode());
            return result;
        }
    }
}
