package software.amazon.awscdk.interfaces.apigatewayv2;

/**
 * A reference to a IntegrationResponse resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.apigatewayv2.*;
 * IntegrationResponseReference integrationResponseReference = IntegrationResponseReference.builder()
 *         .apiId("apiId")
 *         .integrationId("integrationId")
 *         .integrationResponseId("integrationResponseId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_apigatewayv2.IntegrationResponseReference")
@software.amazon.jsii.Jsii.Proxy(IntegrationResponseReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationResponseReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApiId of the IntegrationResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The IntegrationId of the IntegrationResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationId();

    /**
     * The IntegrationResponseId of the IntegrationResponse resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationResponseId();

    /**
     * @return a {@link Builder} of {@link IntegrationResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationResponseReference> {
        java.lang.String apiId;
        java.lang.String integrationId;
        java.lang.String integrationResponseId;

        /**
         * Sets the value of {@link IntegrationResponseReference#getApiId}
         * @param apiId The ApiId of the IntegrationResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponseReference#getIntegrationId}
         * @param integrationId The IntegrationId of the IntegrationResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationId(java.lang.String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponseReference#getIntegrationResponseId}
         * @param integrationResponseId The IntegrationResponseId of the IntegrationResponse resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponseId(java.lang.String integrationResponseId) {
            this.integrationResponseId = integrationResponseId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationResponseReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationResponseReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationResponseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponseReference {
        private final java.lang.String apiId;
        private final java.lang.String integrationId;
        private final java.lang.String integrationResponseId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationId = software.amazon.jsii.Kernel.get(this, "integrationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationResponseId = software.amazon.jsii.Kernel.get(this, "integrationResponseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.integrationId = java.util.Objects.requireNonNull(builder.integrationId, "integrationId is required");
            this.integrationResponseId = java.util.Objects.requireNonNull(builder.integrationResponseId, "integrationResponseId is required");
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getIntegrationId() {
            return this.integrationId;
        }

        @Override
        public final java.lang.String getIntegrationResponseId() {
            return this.integrationResponseId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("integrationId", om.valueToTree(this.getIntegrationId()));
            data.set("integrationResponseId", om.valueToTree(this.getIntegrationResponseId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_apigatewayv2.IntegrationResponseReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationResponseReference.Jsii$Proxy that = (IntegrationResponseReference.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!integrationId.equals(that.integrationId)) return false;
            return this.integrationResponseId.equals(that.integrationResponseId);
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.integrationId.hashCode());
            result = 31 * result + (this.integrationResponseId.hashCode());
            return result;
        }
    }
}
