package software.amazon.awscdk.interfaces.athena;

/**
 * A reference to a DataCatalog resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.athena.*;
 * DataCatalogReference dataCatalogReference = DataCatalogReference.builder()
 *         .dataCatalogName("dataCatalogName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.964Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_athena.DataCatalogReference")
@software.amazon.jsii.Jsii.Proxy(DataCatalogReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataCatalogReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the DataCatalog resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataCatalogName();

    /**
     * @return a {@link Builder} of {@link DataCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataCatalogReference> {
        java.lang.String dataCatalogName;

        /**
         * Sets the value of {@link DataCatalogReference#getDataCatalogName}
         * @param dataCatalogName The Name of the DataCatalog resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogName(java.lang.String dataCatalogName) {
            this.dataCatalogName = dataCatalogName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataCatalogReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataCatalogReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataCatalogReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogReference {
        private final java.lang.String dataCatalogName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataCatalogName = software.amazon.jsii.Kernel.get(this, "dataCatalogName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataCatalogName = java.util.Objects.requireNonNull(builder.dataCatalogName, "dataCatalogName is required");
        }

        @Override
        public final java.lang.String getDataCatalogName() {
            return this.dataCatalogName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataCatalogName", om.valueToTree(this.getDataCatalogName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_athena.DataCatalogReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataCatalogReference.Jsii$Proxy that = (DataCatalogReference.Jsii$Proxy) o;

            return this.dataCatalogName.equals(that.dataCatalogName);
        }

        @Override
        public final int hashCode() {
            int result = this.dataCatalogName.hashCode();
            return result;
        }
    }
}
