package software.amazon.awscdk.interfaces.autoscaling;

/**
 * A reference to a LaunchConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.autoscaling.*;
 * LaunchConfigurationReference launchConfigurationReference = LaunchConfigurationReference.builder()
 *         .launchConfigurationName("launchConfigurationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.979Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_autoscaling.LaunchConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(LaunchConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The LaunchConfigurationName of the LaunchConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLaunchConfigurationName();

    /**
     * @return a {@link Builder} of {@link LaunchConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchConfigurationReference> {
        java.lang.String launchConfigurationName;

        /**
         * Sets the value of {@link LaunchConfigurationReference#getLaunchConfigurationName}
         * @param launchConfigurationName The LaunchConfigurationName of the LaunchConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchConfigurationName(java.lang.String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchConfigurationReference {
        private final java.lang.String launchConfigurationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.launchConfigurationName = software.amazon.jsii.Kernel.get(this, "launchConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchConfigurationName = java.util.Objects.requireNonNull(builder.launchConfigurationName, "launchConfigurationName is required");
        }

        @Override
        public final java.lang.String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("launchConfigurationName", om.valueToTree(this.getLaunchConfigurationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_autoscaling.LaunchConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchConfigurationReference.Jsii$Proxy that = (LaunchConfigurationReference.Jsii$Proxy) o;

            return this.launchConfigurationName.equals(that.launchConfigurationName);
        }

        @Override
        public final int hashCode() {
            int result = this.launchConfigurationName.hashCode();
            return result;
        }
    }
}
