package software.amazon.awscdk.interfaces.backup;

/**
 * A reference to a BackupPlan resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.backup.*;
 * BackupPlanReference backupPlanReference = BackupPlanReference.builder()
 *         .backupPlanArn("backupPlanArn")
 *         .backupPlanId("backupPlanId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.984Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_backup.BackupPlanReference")
@software.amazon.jsii.Jsii.Proxy(BackupPlanReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupPlanReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the BackupPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanArn();

    /**
     * The BackupPlanId of the BackupPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanId();

    /**
     * @return a {@link Builder} of {@link BackupPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupPlanReference> {
        java.lang.String backupPlanArn;
        java.lang.String backupPlanId;

        /**
         * Sets the value of {@link BackupPlanReference#getBackupPlanArn}
         * @param backupPlanArn The ARN of the BackupPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanArn(java.lang.String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanReference#getBackupPlanId}
         * @param backupPlanId The BackupPlanId of the BackupPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanId(java.lang.String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupPlanReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupPlanReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanReference {
        private final java.lang.String backupPlanArn;
        private final java.lang.String backupPlanId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupPlanArn = software.amazon.jsii.Kernel.get(this, "backupPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupPlanId = software.amazon.jsii.Kernel.get(this, "backupPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupPlanArn = java.util.Objects.requireNonNull(builder.backupPlanArn, "backupPlanArn is required");
            this.backupPlanId = java.util.Objects.requireNonNull(builder.backupPlanId, "backupPlanId is required");
        }

        @Override
        public final java.lang.String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        @Override
        public final java.lang.String getBackupPlanId() {
            return this.backupPlanId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupPlanArn", om.valueToTree(this.getBackupPlanArn()));
            data.set("backupPlanId", om.valueToTree(this.getBackupPlanId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_backup.BackupPlanReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupPlanReference.Jsii$Proxy that = (BackupPlanReference.Jsii$Proxy) o;

            if (!backupPlanArn.equals(that.backupPlanArn)) return false;
            return this.backupPlanId.equals(that.backupPlanId);
        }

        @Override
        public final int hashCode() {
            int result = this.backupPlanArn.hashCode();
            result = 31 * result + (this.backupPlanId.hashCode());
            return result;
        }
    }
}
