package software.amazon.awscdk.interfaces.backup;

/**
 * A reference to a RestoreTestingPlan resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.backup.*;
 * RestoreTestingPlanReference restoreTestingPlanReference = RestoreTestingPlanReference.builder()
 *         .restoreTestingPlanArn("restoreTestingPlanArn")
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.988Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_backup.RestoreTestingPlanReference")
@software.amazon.jsii.Jsii.Proxy(RestoreTestingPlanReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestoreTestingPlanReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RestoreTestingPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanArn();

    /**
     * The RestoreTestingPlanName of the RestoreTestingPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName();

    /**
     * @return a {@link Builder} of {@link RestoreTestingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestoreTestingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestoreTestingPlanReference> {
        java.lang.String restoreTestingPlanArn;
        java.lang.String restoreTestingPlanName;

        /**
         * Sets the value of {@link RestoreTestingPlanReference#getRestoreTestingPlanArn}
         * @param restoreTestingPlanArn The ARN of the RestoreTestingPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanArn(java.lang.String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        /**
         * Sets the value of {@link RestoreTestingPlanReference#getRestoreTestingPlanName}
         * @param restoreTestingPlanName The RestoreTestingPlanName of the RestoreTestingPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(java.lang.String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestoreTestingPlanReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestoreTestingPlanReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RestoreTestingPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestoreTestingPlanReference {
        private final java.lang.String restoreTestingPlanArn;
        private final java.lang.String restoreTestingPlanName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restoreTestingPlanArn = software.amazon.jsii.Kernel.get(this, "restoreTestingPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreTestingPlanName = software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restoreTestingPlanArn = java.util.Objects.requireNonNull(builder.restoreTestingPlanArn, "restoreTestingPlanArn is required");
            this.restoreTestingPlanName = java.util.Objects.requireNonNull(builder.restoreTestingPlanName, "restoreTestingPlanName is required");
        }

        @Override
        public final java.lang.String getRestoreTestingPlanArn() {
            return this.restoreTestingPlanArn;
        }

        @Override
        public final java.lang.String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restoreTestingPlanArn", om.valueToTree(this.getRestoreTestingPlanArn()));
            data.set("restoreTestingPlanName", om.valueToTree(this.getRestoreTestingPlanName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_backup.RestoreTestingPlanReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestoreTestingPlanReference.Jsii$Proxy that = (RestoreTestingPlanReference.Jsii$Proxy) o;

            if (!restoreTestingPlanArn.equals(that.restoreTestingPlanArn)) return false;
            return this.restoreTestingPlanName.equals(that.restoreTestingPlanName);
        }

        @Override
        public final int hashCode() {
            int result = this.restoreTestingPlanArn.hashCode();
            result = 31 * result + (this.restoreTestingPlanName.hashCode());
            return result;
        }
    }
}
