package software.amazon.awscdk.interfaces.backup;

/**
 * A reference to a RestoreTestingSelection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.backup.*;
 * RestoreTestingSelectionReference restoreTestingSelectionReference = RestoreTestingSelectionReference.builder()
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .restoreTestingSelectionName("restoreTestingSelectionName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.988Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_backup.RestoreTestingSelectionReference")
@software.amazon.jsii.Jsii.Proxy(RestoreTestingSelectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestoreTestingSelectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The RestoreTestingPlanName of the RestoreTestingSelection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName();

    /**
     * The RestoreTestingSelectionName of the RestoreTestingSelection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingSelectionName();

    /**
     * @return a {@link Builder} of {@link RestoreTestingSelectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestoreTestingSelectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestoreTestingSelectionReference> {
        java.lang.String restoreTestingPlanName;
        java.lang.String restoreTestingSelectionName;

        /**
         * Sets the value of {@link RestoreTestingSelectionReference#getRestoreTestingPlanName}
         * @param restoreTestingPlanName The RestoreTestingPlanName of the RestoreTestingSelection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(java.lang.String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        /**
         * Sets the value of {@link RestoreTestingSelectionReference#getRestoreTestingSelectionName}
         * @param restoreTestingSelectionName The RestoreTestingSelectionName of the RestoreTestingSelection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingSelectionName(java.lang.String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestoreTestingSelectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestoreTestingSelectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RestoreTestingSelectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestoreTestingSelectionReference {
        private final java.lang.String restoreTestingPlanName;
        private final java.lang.String restoreTestingSelectionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restoreTestingPlanName = software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreTestingSelectionName = software.amazon.jsii.Kernel.get(this, "restoreTestingSelectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restoreTestingPlanName = java.util.Objects.requireNonNull(builder.restoreTestingPlanName, "restoreTestingPlanName is required");
            this.restoreTestingSelectionName = java.util.Objects.requireNonNull(builder.restoreTestingSelectionName, "restoreTestingSelectionName is required");
        }

        @Override
        public final java.lang.String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        @Override
        public final java.lang.String getRestoreTestingSelectionName() {
            return this.restoreTestingSelectionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restoreTestingPlanName", om.valueToTree(this.getRestoreTestingPlanName()));
            data.set("restoreTestingSelectionName", om.valueToTree(this.getRestoreTestingSelectionName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_backup.RestoreTestingSelectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestoreTestingSelectionReference.Jsii$Proxy that = (RestoreTestingSelectionReference.Jsii$Proxy) o;

            if (!restoreTestingPlanName.equals(that.restoreTestingPlanName)) return false;
            return this.restoreTestingSelectionName.equals(that.restoreTestingSelectionName);
        }

        @Override
        public final int hashCode() {
            int result = this.restoreTestingPlanName.hashCode();
            result = 31 * result + (this.restoreTestingSelectionName.hashCode());
            return result;
        }
    }
}
