package software.amazon.awscdk.interfaces.batch;

/**
 * A reference to a ServiceEnvironment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.batch.*;
 * ServiceEnvironmentReference serviceEnvironmentReference = ServiceEnvironmentReference.builder()
 *         .serviceEnvironmentArn("serviceEnvironmentArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.993Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_batch.ServiceEnvironmentReference")
@software.amazon.jsii.Jsii.Proxy(ServiceEnvironmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceEnvironmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ServiceEnvironmentArn of the ServiceEnvironment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceEnvironmentArn();

    /**
     * @return a {@link Builder} of {@link ServiceEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceEnvironmentReference> {
        java.lang.String serviceEnvironmentArn;

        /**
         * Sets the value of {@link ServiceEnvironmentReference#getServiceEnvironmentArn}
         * @param serviceEnvironmentArn The ServiceEnvironmentArn of the ServiceEnvironment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceEnvironmentArn(java.lang.String serviceEnvironmentArn) {
            this.serviceEnvironmentArn = serviceEnvironmentArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceEnvironmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceEnvironmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceEnvironmentReference {
        private final java.lang.String serviceEnvironmentArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceEnvironmentArn = software.amazon.jsii.Kernel.get(this, "serviceEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceEnvironmentArn = java.util.Objects.requireNonNull(builder.serviceEnvironmentArn, "serviceEnvironmentArn is required");
        }

        @Override
        public final java.lang.String getServiceEnvironmentArn() {
            return this.serviceEnvironmentArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceEnvironmentArn", om.valueToTree(this.getServiceEnvironmentArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_batch.ServiceEnvironmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceEnvironmentReference.Jsii$Proxy that = (ServiceEnvironmentReference.Jsii$Proxy) o;

            return this.serviceEnvironmentArn.equals(that.serviceEnvironmentArn);
        }

        @Override
        public final int hashCode() {
            int result = this.serviceEnvironmentArn.hashCode();
            return result;
        }
    }
}
