package software.amazon.awscdk.interfaces.bedrock;

/**
 * A reference to a AgentAlias resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.bedrock.*;
 * AgentAliasReference agentAliasReference = AgentAliasReference.builder()
 *         .agentAliasArn("agentAliasArn")
 *         .agentAliasId("agentAliasId")
 *         .agentId("agentId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.994Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_bedrock.AgentAliasReference")
@software.amazon.jsii.Jsii.Proxy(AgentAliasReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AgentAliasReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AgentAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentAliasArn();

    /**
     * The AgentAliasId of the AgentAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentAliasId();

    /**
     * The AgentId of the AgentAlias resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentId();

    /**
     * @return a {@link Builder} of {@link AgentAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AgentAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AgentAliasReference> {
        java.lang.String agentAliasArn;
        java.lang.String agentAliasId;
        java.lang.String agentId;

        /**
         * Sets the value of {@link AgentAliasReference#getAgentAliasArn}
         * @param agentAliasArn The ARN of the AgentAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentAliasArn(java.lang.String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
            return this;
        }

        /**
         * Sets the value of {@link AgentAliasReference#getAgentAliasId}
         * @param agentAliasId The AgentAliasId of the AgentAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentAliasId(java.lang.String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        /**
         * Sets the value of {@link AgentAliasReference#getAgentId}
         * @param agentId The AgentId of the AgentAlias resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentId(java.lang.String agentId) {
            this.agentId = agentId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AgentAliasReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AgentAliasReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AgentAliasReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentAliasReference {
        private final java.lang.String agentAliasArn;
        private final java.lang.String agentAliasId;
        private final java.lang.String agentId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentAliasArn = software.amazon.jsii.Kernel.get(this, "agentAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentAliasId = software.amazon.jsii.Kernel.get(this, "agentAliasId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentId = software.amazon.jsii.Kernel.get(this, "agentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentAliasArn = java.util.Objects.requireNonNull(builder.agentAliasArn, "agentAliasArn is required");
            this.agentAliasId = java.util.Objects.requireNonNull(builder.agentAliasId, "agentAliasId is required");
            this.agentId = java.util.Objects.requireNonNull(builder.agentId, "agentId is required");
        }

        @Override
        public final java.lang.String getAgentAliasArn() {
            return this.agentAliasArn;
        }

        @Override
        public final java.lang.String getAgentAliasId() {
            return this.agentAliasId;
        }

        @Override
        public final java.lang.String getAgentId() {
            return this.agentId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentAliasArn", om.valueToTree(this.getAgentAliasArn()));
            data.set("agentAliasId", om.valueToTree(this.getAgentAliasId()));
            data.set("agentId", om.valueToTree(this.getAgentId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_bedrock.AgentAliasReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AgentAliasReference.Jsii$Proxy that = (AgentAliasReference.Jsii$Proxy) o;

            if (!agentAliasArn.equals(that.agentAliasArn)) return false;
            if (!agentAliasId.equals(that.agentAliasId)) return false;
            return this.agentId.equals(that.agentId);
        }

        @Override
        public final int hashCode() {
            int result = this.agentAliasArn.hashCode();
            result = 31 * result + (this.agentAliasId.hashCode());
            result = 31 * result + (this.agentId.hashCode());
            return result;
        }
    }
}
