package software.amazon.awscdk.interfaces.bedrock;

/**
 * A reference to a Agent resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.bedrock.*;
 * AgentReference agentReference = AgentReference.builder()
 *         .agentArn("agentArn")
 *         .agentId("agentId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:02.994Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_bedrock.AgentReference")
@software.amazon.jsii.Jsii.Proxy(AgentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AgentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Agent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentArn();

    /**
     * The AgentId of the Agent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentId();

    /**
     * @return a {@link Builder} of {@link AgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AgentReference> {
        java.lang.String agentArn;
        java.lang.String agentId;

        /**
         * Sets the value of {@link AgentReference#getAgentArn}
         * @param agentArn The ARN of the Agent resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArn(java.lang.String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        /**
         * Sets the value of {@link AgentReference#getAgentId}
         * @param agentId The AgentId of the Agent resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentId(java.lang.String agentId) {
            this.agentId = agentId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AgentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AgentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentReference {
        private final java.lang.String agentArn;
        private final java.lang.String agentId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentArn = software.amazon.jsii.Kernel.get(this, "agentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentId = software.amazon.jsii.Kernel.get(this, "agentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentArn = java.util.Objects.requireNonNull(builder.agentArn, "agentArn is required");
            this.agentId = java.util.Objects.requireNonNull(builder.agentId, "agentId is required");
        }

        @Override
        public final java.lang.String getAgentArn() {
            return this.agentArn;
        }

        @Override
        public final java.lang.String getAgentId() {
            return this.agentId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentArn", om.valueToTree(this.getAgentArn()));
            data.set("agentId", om.valueToTree(this.getAgentId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_bedrock.AgentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AgentReference.Jsii$Proxy that = (AgentReference.Jsii$Proxy) o;

            if (!agentArn.equals(that.agentArn)) return false;
            return this.agentId.equals(that.agentId);
        }

        @Override
        public final int hashCode() {
            int result = this.agentArn.hashCode();
            result = 31 * result + (this.agentId.hashCode());
            return result;
        }
    }
}
