package software.amazon.awscdk.interfaces.bedrockagentcore;

/**
 * A reference to a RuntimeEndpoint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.bedrockagentcore.*;
 * RuntimeEndpointReference runtimeEndpointReference = RuntimeEndpointReference.builder()
 *         .agentRuntimeEndpointArn("agentRuntimeEndpointArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.018Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_bedrockagentcore.RuntimeEndpointReference")
@software.amazon.jsii.Jsii.Proxy(RuntimeEndpointReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuntimeEndpointReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AgentRuntimeEndpointArn of the RuntimeEndpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentRuntimeEndpointArn();

    /**
     * @return a {@link Builder} of {@link RuntimeEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuntimeEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuntimeEndpointReference> {
        java.lang.String agentRuntimeEndpointArn;

        /**
         * Sets the value of {@link RuntimeEndpointReference#getAgentRuntimeEndpointArn}
         * @param agentRuntimeEndpointArn The AgentRuntimeEndpointArn of the RuntimeEndpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeEndpointArn(java.lang.String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuntimeEndpointReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuntimeEndpointReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuntimeEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimeEndpointReference {
        private final java.lang.String agentRuntimeEndpointArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentRuntimeEndpointArn = software.amazon.jsii.Kernel.get(this, "agentRuntimeEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentRuntimeEndpointArn = java.util.Objects.requireNonNull(builder.agentRuntimeEndpointArn, "agentRuntimeEndpointArn is required");
        }

        @Override
        public final java.lang.String getAgentRuntimeEndpointArn() {
            return this.agentRuntimeEndpointArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentRuntimeEndpointArn", om.valueToTree(this.getAgentRuntimeEndpointArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_bedrockagentcore.RuntimeEndpointReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuntimeEndpointReference.Jsii$Proxy that = (RuntimeEndpointReference.Jsii$Proxy) o;

            return this.agentRuntimeEndpointArn.equals(that.agentRuntimeEndpointArn);
        }

        @Override
        public final int hashCode() {
            int result = this.agentRuntimeEndpointArn.hashCode();
            return result;
        }
    }
}
