package software.amazon.awscdk.interfaces.budgets;

/**
 * A reference to a BudgetsAction resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.budgets.*;
 * BudgetsActionReference budgetsActionReference = BudgetsActionReference.builder()
 *         .actionId("actionId")
 *         .budgetName("budgetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_budgets.BudgetsActionReference")
@software.amazon.jsii.Jsii.Proxy(BudgetsActionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BudgetsActionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ActionId of the BudgetsAction resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionId();

    /**
     * The BudgetName of the BudgetsAction resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBudgetName();

    /**
     * @return a {@link Builder} of {@link BudgetsActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BudgetsActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BudgetsActionReference> {
        java.lang.String actionId;
        java.lang.String budgetName;

        /**
         * Sets the value of {@link BudgetsActionReference#getActionId}
         * @param actionId The ActionId of the BudgetsAction resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionId(java.lang.String actionId) {
            this.actionId = actionId;
            return this;
        }

        /**
         * Sets the value of {@link BudgetsActionReference#getBudgetName}
         * @param budgetName The BudgetName of the BudgetsAction resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budgetName(java.lang.String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BudgetsActionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BudgetsActionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BudgetsActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BudgetsActionReference {
        private final java.lang.String actionId;
        private final java.lang.String budgetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionId = software.amazon.jsii.Kernel.get(this, "actionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.budgetName = software.amazon.jsii.Kernel.get(this, "budgetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionId = java.util.Objects.requireNonNull(builder.actionId, "actionId is required");
            this.budgetName = java.util.Objects.requireNonNull(builder.budgetName, "budgetName is required");
        }

        @Override
        public final java.lang.String getActionId() {
            return this.actionId;
        }

        @Override
        public final java.lang.String getBudgetName() {
            return this.budgetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionId", om.valueToTree(this.getActionId()));
            data.set("budgetName", om.valueToTree(this.getBudgetName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_budgets.BudgetsActionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BudgetsActionReference.Jsii$Proxy that = (BudgetsActionReference.Jsii$Proxy) o;

            if (!actionId.equals(that.actionId)) return false;
            return this.budgetName.equals(that.budgetName);
        }

        @Override
        public final int hashCode() {
            int result = this.actionId.hashCode();
            result = 31 * result + (this.budgetName.hashCode());
            return result;
        }
    }
}
