package software.amazon.awscdk.interfaces.cloudformation;

/**
 * A reference to a Publisher resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudformation.*;
 * PublisherReference publisherReference = PublisherReference.builder()
 *         .publisherId("publisherId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.053Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudformation.PublisherReference")
@software.amazon.jsii.Jsii.Proxy(PublisherReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublisherReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PublisherId of the Publisher resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublisherId();

    /**
     * @return a {@link Builder} of {@link PublisherReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublisherReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublisherReference> {
        java.lang.String publisherId;

        /**
         * Sets the value of {@link PublisherReference#getPublisherId}
         * @param publisherId The PublisherId of the Publisher resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publisherId(java.lang.String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublisherReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublisherReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublisherReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublisherReference {
        private final java.lang.String publisherId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publisherId = software.amazon.jsii.Kernel.get(this, "publisherId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publisherId = java.util.Objects.requireNonNull(builder.publisherId, "publisherId is required");
        }

        @Override
        public final java.lang.String getPublisherId() {
            return this.publisherId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publisherId", om.valueToTree(this.getPublisherId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudformation.PublisherReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublisherReference.Jsii$Proxy that = (PublisherReference.Jsii$Proxy) o;

            return this.publisherId.equals(that.publisherId);
        }

        @Override
        public final int hashCode() {
            int result = this.publisherId.hashCode();
            return result;
        }
    }
}
