package software.amazon.awscdk.interfaces.cloudformation;

/**
 * A reference to a ResourceDefaultVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudformation.*;
 * ResourceDefaultVersionReference resourceDefaultVersionReference = ResourceDefaultVersionReference.builder()
 *         .resourceDefaultVersionArn("resourceDefaultVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.054Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudformation.ResourceDefaultVersionReference")
@software.amazon.jsii.Jsii.Proxy(ResourceDefaultVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceDefaultVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ResourceDefaultVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceDefaultVersionArn();

    /**
     * @return a {@link Builder} of {@link ResourceDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceDefaultVersionReference> {
        java.lang.String resourceDefaultVersionArn;

        /**
         * Sets the value of {@link ResourceDefaultVersionReference#getResourceDefaultVersionArn}
         * @param resourceDefaultVersionArn The Arn of the ResourceDefaultVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceDefaultVersionArn(java.lang.String resourceDefaultVersionArn) {
            this.resourceDefaultVersionArn = resourceDefaultVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceDefaultVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceDefaultVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceDefaultVersionReference {
        private final java.lang.String resourceDefaultVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceDefaultVersionArn = software.amazon.jsii.Kernel.get(this, "resourceDefaultVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceDefaultVersionArn = java.util.Objects.requireNonNull(builder.resourceDefaultVersionArn, "resourceDefaultVersionArn is required");
        }

        @Override
        public final java.lang.String getResourceDefaultVersionArn() {
            return this.resourceDefaultVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceDefaultVersionArn", om.valueToTree(this.getResourceDefaultVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudformation.ResourceDefaultVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceDefaultVersionReference.Jsii$Proxy that = (ResourceDefaultVersionReference.Jsii$Proxy) o;

            return this.resourceDefaultVersionArn.equals(that.resourceDefaultVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceDefaultVersionArn.hashCode();
            return result;
        }
    }
}
