package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a DistributionTenant resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * DistributionTenantReference distributionTenantReference = DistributionTenantReference.builder()
 *         .distributionTenantArn("distributionTenantArn")
 *         .distributionTenantId("distributionTenantId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.057Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.DistributionTenantReference")
@software.amazon.jsii.Jsii.Proxy(DistributionTenantReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DistributionTenantReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DistributionTenant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistributionTenantArn();

    /**
     * The Id of the DistributionTenant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistributionTenantId();

    /**
     * @return a {@link Builder} of {@link DistributionTenantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DistributionTenantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DistributionTenantReference> {
        java.lang.String distributionTenantArn;
        java.lang.String distributionTenantId;

        /**
         * Sets the value of {@link DistributionTenantReference#getDistributionTenantArn}
         * @param distributionTenantArn The ARN of the DistributionTenant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionTenantArn(java.lang.String distributionTenantArn) {
            this.distributionTenantArn = distributionTenantArn;
            return this;
        }

        /**
         * Sets the value of {@link DistributionTenantReference#getDistributionTenantId}
         * @param distributionTenantId The Id of the DistributionTenant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionTenantId(java.lang.String distributionTenantId) {
            this.distributionTenantId = distributionTenantId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DistributionTenantReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DistributionTenantReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DistributionTenantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionTenantReference {
        private final java.lang.String distributionTenantArn;
        private final java.lang.String distributionTenantId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.distributionTenantArn = software.amazon.jsii.Kernel.get(this, "distributionTenantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributionTenantId = software.amazon.jsii.Kernel.get(this, "distributionTenantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.distributionTenantArn = java.util.Objects.requireNonNull(builder.distributionTenantArn, "distributionTenantArn is required");
            this.distributionTenantId = java.util.Objects.requireNonNull(builder.distributionTenantId, "distributionTenantId is required");
        }

        @Override
        public final java.lang.String getDistributionTenantArn() {
            return this.distributionTenantArn;
        }

        @Override
        public final java.lang.String getDistributionTenantId() {
            return this.distributionTenantId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("distributionTenantArn", om.valueToTree(this.getDistributionTenantArn()));
            data.set("distributionTenantId", om.valueToTree(this.getDistributionTenantId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.DistributionTenantReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DistributionTenantReference.Jsii$Proxy that = (DistributionTenantReference.Jsii$Proxy) o;

            if (!distributionTenantArn.equals(that.distributionTenantArn)) return false;
            return this.distributionTenantId.equals(that.distributionTenantId);
        }

        @Override
        public final int hashCode() {
            int result = this.distributionTenantArn.hashCode();
            result = 31 * result + (this.distributionTenantId.hashCode());
            return result;
        }
    }
}
