package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a KeyValueStore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * KeyValueStoreReference keyValueStoreReference = KeyValueStoreReference.builder()
 *         .keyValueStoreArn("keyValueStoreArn")
 *         .keyValueStoreName("keyValueStoreName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.064Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.KeyValueStoreReference")
@software.amazon.jsii.Jsii.Proxy(KeyValueStoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyValueStoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the KeyValueStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyValueStoreArn();

    /**
     * The Name of the KeyValueStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyValueStoreName();

    /**
     * @return a {@link Builder} of {@link KeyValueStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyValueStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyValueStoreReference> {
        java.lang.String keyValueStoreArn;
        java.lang.String keyValueStoreName;

        /**
         * Sets the value of {@link KeyValueStoreReference#getKeyValueStoreArn}
         * @param keyValueStoreArn The ARN of the KeyValueStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStoreArn(java.lang.String keyValueStoreArn) {
            this.keyValueStoreArn = keyValueStoreArn;
            return this;
        }

        /**
         * Sets the value of {@link KeyValueStoreReference#getKeyValueStoreName}
         * @param keyValueStoreName The Name of the KeyValueStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStoreName(java.lang.String keyValueStoreName) {
            this.keyValueStoreName = keyValueStoreName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyValueStoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyValueStoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyValueStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValueStoreReference {
        private final java.lang.String keyValueStoreArn;
        private final java.lang.String keyValueStoreName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyValueStoreArn = software.amazon.jsii.Kernel.get(this, "keyValueStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyValueStoreName = software.amazon.jsii.Kernel.get(this, "keyValueStoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyValueStoreArn = java.util.Objects.requireNonNull(builder.keyValueStoreArn, "keyValueStoreArn is required");
            this.keyValueStoreName = java.util.Objects.requireNonNull(builder.keyValueStoreName, "keyValueStoreName is required");
        }

        @Override
        public final java.lang.String getKeyValueStoreArn() {
            return this.keyValueStoreArn;
        }

        @Override
        public final java.lang.String getKeyValueStoreName() {
            return this.keyValueStoreName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyValueStoreArn", om.valueToTree(this.getKeyValueStoreArn()));
            data.set("keyValueStoreName", om.valueToTree(this.getKeyValueStoreName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.KeyValueStoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyValueStoreReference.Jsii$Proxy that = (KeyValueStoreReference.Jsii$Proxy) o;

            if (!keyValueStoreArn.equals(that.keyValueStoreArn)) return false;
            return this.keyValueStoreName.equals(that.keyValueStoreName);
        }

        @Override
        public final int hashCode() {
            int result = this.keyValueStoreArn.hashCode();
            result = 31 * result + (this.keyValueStoreName.hashCode());
            return result;
        }
    }
}
