package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a OriginAccessControl resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * OriginAccessControlReference originAccessControlReference = OriginAccessControlReference.builder()
 *         .originAccessControlId("originAccessControlId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.OriginAccessControlReference")
@software.amazon.jsii.Jsii.Proxy(OriginAccessControlReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginAccessControlReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the OriginAccessControl resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessControlId();

    /**
     * @return a {@link Builder} of {@link OriginAccessControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginAccessControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginAccessControlReference> {
        java.lang.String originAccessControlId;

        /**
         * Sets the value of {@link OriginAccessControlReference#getOriginAccessControlId}
         * @param originAccessControlId The Id of the OriginAccessControl resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlId(java.lang.String originAccessControlId) {
            this.originAccessControlId = originAccessControlId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginAccessControlReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginAccessControlReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginAccessControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginAccessControlReference {
        private final java.lang.String originAccessControlId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originAccessControlId = software.amazon.jsii.Kernel.get(this, "originAccessControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originAccessControlId = java.util.Objects.requireNonNull(builder.originAccessControlId, "originAccessControlId is required");
        }

        @Override
        public final java.lang.String getOriginAccessControlId() {
            return this.originAccessControlId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("originAccessControlId", om.valueToTree(this.getOriginAccessControlId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.OriginAccessControlReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginAccessControlReference.Jsii$Proxy that = (OriginAccessControlReference.Jsii$Proxy) o;

            return this.originAccessControlId.equals(that.originAccessControlId);
        }

        @Override
        public final int hashCode() {
            int result = this.originAccessControlId.hashCode();
            return result;
        }
    }
}
