package software.amazon.awscdk.interfaces.cloudfront;

/**
 * A reference to a RealtimeLogConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudfront.*;
 * RealtimeLogConfigReference realtimeLogConfigReference = RealtimeLogConfigReference.builder()
 *         .realtimeLogConfigArn("realtimeLogConfigArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudfront.RealtimeLogConfigReference")
@software.amazon.jsii.Jsii.Proxy(RealtimeLogConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RealtimeLogConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the RealtimeLogConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRealtimeLogConfigArn();

    /**
     * @return a {@link Builder} of {@link RealtimeLogConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RealtimeLogConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RealtimeLogConfigReference> {
        java.lang.String realtimeLogConfigArn;

        /**
         * Sets the value of {@link RealtimeLogConfigReference#getRealtimeLogConfigArn}
         * @param realtimeLogConfigArn The Arn of the RealtimeLogConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeLogConfigArn(java.lang.String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RealtimeLogConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RealtimeLogConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RealtimeLogConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RealtimeLogConfigReference {
        private final java.lang.String realtimeLogConfigArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.realtimeLogConfigArn = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.realtimeLogConfigArn = java.util.Objects.requireNonNull(builder.realtimeLogConfigArn, "realtimeLogConfigArn is required");
        }

        @Override
        public final java.lang.String getRealtimeLogConfigArn() {
            return this.realtimeLogConfigArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("realtimeLogConfigArn", om.valueToTree(this.getRealtimeLogConfigArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudfront.RealtimeLogConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RealtimeLogConfigReference.Jsii$Proxy that = (RealtimeLogConfigReference.Jsii$Proxy) o;

            return this.realtimeLogConfigArn.equals(that.realtimeLogConfigArn);
        }

        @Override
        public final int hashCode() {
            int result = this.realtimeLogConfigArn.hashCode();
            return result;
        }
    }
}
