package software.amazon.awscdk.interfaces.cloudtrail;

/**
 * A reference to a EventDataStore resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudtrail.*;
 * EventDataStoreReference eventDataStoreReference = EventDataStoreReference.builder()
 *         .eventDataStoreArn("eventDataStoreArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudtrail.EventDataStoreReference")
@software.amazon.jsii.Jsii.Proxy(EventDataStoreReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventDataStoreReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EventDataStoreArn of the EventDataStore resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventDataStoreArn();

    /**
     * @return a {@link Builder} of {@link EventDataStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventDataStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventDataStoreReference> {
        java.lang.String eventDataStoreArn;

        /**
         * Sets the value of {@link EventDataStoreReference#getEventDataStoreArn}
         * @param eventDataStoreArn The EventDataStoreArn of the EventDataStore resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDataStoreArn(java.lang.String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventDataStoreReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventDataStoreReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventDataStoreReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventDataStoreReference {
        private final java.lang.String eventDataStoreArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventDataStoreArn = software.amazon.jsii.Kernel.get(this, "eventDataStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventDataStoreArn = java.util.Objects.requireNonNull(builder.eventDataStoreArn, "eventDataStoreArn is required");
        }

        @Override
        public final java.lang.String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventDataStoreArn", om.valueToTree(this.getEventDataStoreArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudtrail.EventDataStoreReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventDataStoreReference.Jsii$Proxy that = (EventDataStoreReference.Jsii$Proxy) o;

            return this.eventDataStoreArn.equals(that.eventDataStoreArn);
        }

        @Override
        public final int hashCode() {
            int result = this.eventDataStoreArn.hashCode();
            return result;
        }
    }
}
