package software.amazon.awscdk.interfaces.cloudwatch;

/**
 * A reference to a InsightRule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.cloudwatch.*;
 * InsightRuleReference insightRuleReference = InsightRuleReference.builder()
 *         .insightRuleArn("insightRuleArn")
 *         .insightRuleId("insightRuleId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.073Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_cloudwatch.InsightRuleReference")
@software.amazon.jsii.Jsii.Proxy(InsightRuleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InsightRuleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the InsightRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInsightRuleArn();

    /**
     * The Id of the InsightRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInsightRuleId();

    /**
     * @return a {@link Builder} of {@link InsightRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InsightRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InsightRuleReference> {
        java.lang.String insightRuleArn;
        java.lang.String insightRuleId;

        /**
         * Sets the value of {@link InsightRuleReference#getInsightRuleArn}
         * @param insightRuleArn The ARN of the InsightRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightRuleArn(java.lang.String insightRuleArn) {
            this.insightRuleArn = insightRuleArn;
            return this;
        }

        /**
         * Sets the value of {@link InsightRuleReference#getInsightRuleId}
         * @param insightRuleId The Id of the InsightRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightRuleId(java.lang.String insightRuleId) {
            this.insightRuleId = insightRuleId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InsightRuleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InsightRuleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InsightRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InsightRuleReference {
        private final java.lang.String insightRuleArn;
        private final java.lang.String insightRuleId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.insightRuleArn = software.amazon.jsii.Kernel.get(this, "insightRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insightRuleId = software.amazon.jsii.Kernel.get(this, "insightRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.insightRuleArn = java.util.Objects.requireNonNull(builder.insightRuleArn, "insightRuleArn is required");
            this.insightRuleId = java.util.Objects.requireNonNull(builder.insightRuleId, "insightRuleId is required");
        }

        @Override
        public final java.lang.String getInsightRuleArn() {
            return this.insightRuleArn;
        }

        @Override
        public final java.lang.String getInsightRuleId() {
            return this.insightRuleId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("insightRuleArn", om.valueToTree(this.getInsightRuleArn()));
            data.set("insightRuleId", om.valueToTree(this.getInsightRuleId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_cloudwatch.InsightRuleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InsightRuleReference.Jsii$Proxy that = (InsightRuleReference.Jsii$Proxy) o;

            if (!insightRuleArn.equals(that.insightRuleArn)) return false;
            return this.insightRuleId.equals(that.insightRuleId);
        }

        @Override
        public final int hashCode() {
            int result = this.insightRuleArn.hashCode();
            result = 31 * result + (this.insightRuleId.hashCode());
            return result;
        }
    }
}
