package software.amazon.awscdk.interfaces.codebuild;

/**
 * A reference to a SourceCredential resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.codebuild.*;
 * SourceCredentialReference sourceCredentialReference = SourceCredentialReference.builder()
 *         .sourceCredentialId("sourceCredentialId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.078Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_codebuild.SourceCredentialReference")
@software.amazon.jsii.Jsii.Proxy(SourceCredentialReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceCredentialReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the SourceCredential resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceCredentialId();

    /**
     * @return a {@link Builder} of {@link SourceCredentialReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceCredentialReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceCredentialReference> {
        java.lang.String sourceCredentialId;

        /**
         * Sets the value of {@link SourceCredentialReference#getSourceCredentialId}
         * @param sourceCredentialId The Id of the SourceCredential resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceCredentialId(java.lang.String sourceCredentialId) {
            this.sourceCredentialId = sourceCredentialId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceCredentialReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceCredentialReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceCredentialReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceCredentialReference {
        private final java.lang.String sourceCredentialId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceCredentialId = software.amazon.jsii.Kernel.get(this, "sourceCredentialId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceCredentialId = java.util.Objects.requireNonNull(builder.sourceCredentialId, "sourceCredentialId is required");
        }

        @Override
        public final java.lang.String getSourceCredentialId() {
            return this.sourceCredentialId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceCredentialId", om.valueToTree(this.getSourceCredentialId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_codebuild.SourceCredentialReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceCredentialReference.Jsii$Proxy that = (SourceCredentialReference.Jsii$Proxy) o;

            return this.sourceCredentialId.equals(that.sourceCredentialId);
        }

        @Override
        public final int hashCode() {
            int result = this.sourceCredentialId.hashCode();
            return result;
        }
    }
}
