package software.amazon.awscdk.interfaces.config;

/**
 * A reference to a AggregationAuthorization resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.config.*;
 * AggregationAuthorizationReference aggregationAuthorizationReference = AggregationAuthorizationReference.builder()
 *         .aggregationAuthorizationArn("aggregationAuthorizationArn")
 *         .authorizedAccountId("authorizedAccountId")
 *         .authorizedAwsRegion("authorizedAwsRegion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.108Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_config.AggregationAuthorizationReference")
@software.amazon.jsii.Jsii.Proxy(AggregationAuthorizationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AggregationAuthorizationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AggregationAuthorization resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAggregationAuthorizationArn();

    /**
     * The AuthorizedAccountId of the AggregationAuthorization resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizedAccountId();

    /**
     * The AuthorizedAwsRegion of the AggregationAuthorization resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizedAwsRegion();

    /**
     * @return a {@link Builder} of {@link AggregationAuthorizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AggregationAuthorizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AggregationAuthorizationReference> {
        java.lang.String aggregationAuthorizationArn;
        java.lang.String authorizedAccountId;
        java.lang.String authorizedAwsRegion;

        /**
         * Sets the value of {@link AggregationAuthorizationReference#getAggregationAuthorizationArn}
         * @param aggregationAuthorizationArn The ARN of the AggregationAuthorization resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aggregationAuthorizationArn(java.lang.String aggregationAuthorizationArn) {
            this.aggregationAuthorizationArn = aggregationAuthorizationArn;
            return this;
        }

        /**
         * Sets the value of {@link AggregationAuthorizationReference#getAuthorizedAccountId}
         * @param authorizedAccountId The AuthorizedAccountId of the AggregationAuthorization resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedAccountId(java.lang.String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        /**
         * Sets the value of {@link AggregationAuthorizationReference#getAuthorizedAwsRegion}
         * @param authorizedAwsRegion The AuthorizedAwsRegion of the AggregationAuthorization resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizedAwsRegion(java.lang.String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AggregationAuthorizationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AggregationAuthorizationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AggregationAuthorizationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationAuthorizationReference {
        private final java.lang.String aggregationAuthorizationArn;
        private final java.lang.String authorizedAccountId;
        private final java.lang.String authorizedAwsRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aggregationAuthorizationArn = software.amazon.jsii.Kernel.get(this, "aggregationAuthorizationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizedAccountId = software.amazon.jsii.Kernel.get(this, "authorizedAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizedAwsRegion = software.amazon.jsii.Kernel.get(this, "authorizedAwsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aggregationAuthorizationArn = java.util.Objects.requireNonNull(builder.aggregationAuthorizationArn, "aggregationAuthorizationArn is required");
            this.authorizedAccountId = java.util.Objects.requireNonNull(builder.authorizedAccountId, "authorizedAccountId is required");
            this.authorizedAwsRegion = java.util.Objects.requireNonNull(builder.authorizedAwsRegion, "authorizedAwsRegion is required");
        }

        @Override
        public final java.lang.String getAggregationAuthorizationArn() {
            return this.aggregationAuthorizationArn;
        }

        @Override
        public final java.lang.String getAuthorizedAccountId() {
            return this.authorizedAccountId;
        }

        @Override
        public final java.lang.String getAuthorizedAwsRegion() {
            return this.authorizedAwsRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aggregationAuthorizationArn", om.valueToTree(this.getAggregationAuthorizationArn()));
            data.set("authorizedAccountId", om.valueToTree(this.getAuthorizedAccountId()));
            data.set("authorizedAwsRegion", om.valueToTree(this.getAuthorizedAwsRegion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_config.AggregationAuthorizationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AggregationAuthorizationReference.Jsii$Proxy that = (AggregationAuthorizationReference.Jsii$Proxy) o;

            if (!aggregationAuthorizationArn.equals(that.aggregationAuthorizationArn)) return false;
            if (!authorizedAccountId.equals(that.authorizedAccountId)) return false;
            return this.authorizedAwsRegion.equals(that.authorizedAwsRegion);
        }

        @Override
        public final int hashCode() {
            int result = this.aggregationAuthorizationArn.hashCode();
            result = 31 * result + (this.authorizedAccountId.hashCode());
            result = 31 * result + (this.authorizedAwsRegion.hashCode());
            return result;
        }
    }
}
