package software.amazon.awscdk.interfaces.config;

/**
 * A reference to a DeliveryChannel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.config.*;
 * DeliveryChannelReference deliveryChannelReference = DeliveryChannelReference.builder()
 *         .deliveryChannelId("deliveryChannelId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.110Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_config.DeliveryChannelReference")
@software.amazon.jsii.Jsii.Proxy(DeliveryChannelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeliveryChannelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the DeliveryChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeliveryChannelId();

    /**
     * @return a {@link Builder} of {@link DeliveryChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeliveryChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeliveryChannelReference> {
        java.lang.String deliveryChannelId;

        /**
         * Sets the value of {@link DeliveryChannelReference#getDeliveryChannelId}
         * @param deliveryChannelId The Id of the DeliveryChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryChannelId(java.lang.String deliveryChannelId) {
            this.deliveryChannelId = deliveryChannelId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeliveryChannelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeliveryChannelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeliveryChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryChannelReference {
        private final java.lang.String deliveryChannelId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryChannelId = software.amazon.jsii.Kernel.get(this, "deliveryChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryChannelId = java.util.Objects.requireNonNull(builder.deliveryChannelId, "deliveryChannelId is required");
        }

        @Override
        public final java.lang.String getDeliveryChannelId() {
            return this.deliveryChannelId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryChannelId", om.valueToTree(this.getDeliveryChannelId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_config.DeliveryChannelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeliveryChannelReference.Jsii$Proxy that = (DeliveryChannelReference.Jsii$Proxy) o;

            return this.deliveryChannelId.equals(that.deliveryChannelId);
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryChannelId.hashCode();
            return result;
        }
    }
}
