package software.amazon.awscdk.interfaces.controltower;

/**
 * A reference to a LandingZone resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.controltower.*;
 * LandingZoneReference landingZoneReference = LandingZoneReference.builder()
 *         .landingZoneArn("landingZoneArn")
 *         .landingZoneIdentifier("landingZoneIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.143Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_controltower.LandingZoneReference")
@software.amazon.jsii.Jsii.Proxy(LandingZoneReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LandingZoneReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the LandingZone resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLandingZoneArn();

    /**
     * The LandingZoneIdentifier of the LandingZone resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLandingZoneIdentifier();

    /**
     * @return a {@link Builder} of {@link LandingZoneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LandingZoneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LandingZoneReference> {
        java.lang.String landingZoneArn;
        java.lang.String landingZoneIdentifier;

        /**
         * Sets the value of {@link LandingZoneReference#getLandingZoneArn}
         * @param landingZoneArn The ARN of the LandingZone resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder landingZoneArn(java.lang.String landingZoneArn) {
            this.landingZoneArn = landingZoneArn;
            return this;
        }

        /**
         * Sets the value of {@link LandingZoneReference#getLandingZoneIdentifier}
         * @param landingZoneIdentifier The LandingZoneIdentifier of the LandingZone resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder landingZoneIdentifier(java.lang.String landingZoneIdentifier) {
            this.landingZoneIdentifier = landingZoneIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LandingZoneReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LandingZoneReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LandingZoneReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LandingZoneReference {
        private final java.lang.String landingZoneArn;
        private final java.lang.String landingZoneIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.landingZoneArn = software.amazon.jsii.Kernel.get(this, "landingZoneArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.landingZoneIdentifier = software.amazon.jsii.Kernel.get(this, "landingZoneIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.landingZoneArn = java.util.Objects.requireNonNull(builder.landingZoneArn, "landingZoneArn is required");
            this.landingZoneIdentifier = java.util.Objects.requireNonNull(builder.landingZoneIdentifier, "landingZoneIdentifier is required");
        }

        @Override
        public final java.lang.String getLandingZoneArn() {
            return this.landingZoneArn;
        }

        @Override
        public final java.lang.String getLandingZoneIdentifier() {
            return this.landingZoneIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("landingZoneArn", om.valueToTree(this.getLandingZoneArn()));
            data.set("landingZoneIdentifier", om.valueToTree(this.getLandingZoneIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_controltower.LandingZoneReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LandingZoneReference.Jsii$Proxy that = (LandingZoneReference.Jsii$Proxy) o;

            if (!landingZoneArn.equals(that.landingZoneArn)) return false;
            return this.landingZoneIdentifier.equals(that.landingZoneIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.landingZoneArn.hashCode();
            result = 31 * result + (this.landingZoneIdentifier.hashCode());
            return result;
        }
    }
}
