package software.amazon.awscdk.interfaces.devicefarm;

/**
 * A reference to a InstanceProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.devicefarm.*;
 * InstanceProfileReference instanceProfileReference = InstanceProfileReference.builder()
 *         .instanceProfileArn("instanceProfileArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.205Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_devicefarm.InstanceProfileReference")
@software.amazon.jsii.Jsii.Proxy(InstanceProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the InstanceProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileArn();

    /**
     * @return a {@link Builder} of {@link InstanceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceProfileReference> {
        java.lang.String instanceProfileArn;

        /**
         * Sets the value of {@link InstanceProfileReference#getInstanceProfileArn}
         * @param instanceProfileArn The Arn of the InstanceProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileArn(java.lang.String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceProfileReference {
        private final java.lang.String instanceProfileArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceProfileArn = software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceProfileArn = java.util.Objects.requireNonNull(builder.instanceProfileArn, "instanceProfileArn is required");
        }

        @Override
        public final java.lang.String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceProfileArn", om.valueToTree(this.getInstanceProfileArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_devicefarm.InstanceProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceProfileReference.Jsii$Proxy that = (InstanceProfileReference.Jsii$Proxy) o;

            return this.instanceProfileArn.equals(that.instanceProfileArn);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceProfileArn.hashCode();
            return result;
        }
    }
}
