package software.amazon.awscdk.interfaces.devopsguru;

/**
 * A reference to a ResourceCollection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.devopsguru.*;
 * ResourceCollectionReference resourceCollectionReference = ResourceCollectionReference.builder()
 *         .resourceCollectionType("resourceCollectionType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.208Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_devopsguru.ResourceCollectionReference")
@software.amazon.jsii.Jsii.Proxy(ResourceCollectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceCollectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ResourceCollectionType of the ResourceCollection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceCollectionType();

    /**
     * @return a {@link Builder} of {@link ResourceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceCollectionReference> {
        java.lang.String resourceCollectionType;

        /**
         * Sets the value of {@link ResourceCollectionReference#getResourceCollectionType}
         * @param resourceCollectionType The ResourceCollectionType of the ResourceCollection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionType(java.lang.String resourceCollectionType) {
            this.resourceCollectionType = resourceCollectionType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceCollectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceCollectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceCollectionReference {
        private final java.lang.String resourceCollectionType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceCollectionType = software.amazon.jsii.Kernel.get(this, "resourceCollectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceCollectionType = java.util.Objects.requireNonNull(builder.resourceCollectionType, "resourceCollectionType is required");
        }

        @Override
        public final java.lang.String getResourceCollectionType() {
            return this.resourceCollectionType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceCollectionType", om.valueToTree(this.getResourceCollectionType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_devopsguru.ResourceCollectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceCollectionReference.Jsii$Proxy that = (ResourceCollectionReference.Jsii$Proxy) o;

            return this.resourceCollectionType.equals(that.resourceCollectionType);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceCollectionType.hashCode();
            return result;
        }
    }
}
