package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a CarrierGateway resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * CarrierGatewayReference carrierGatewayReference = CarrierGatewayReference.builder()
 *         .carrierGatewayId("carrierGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.223Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.CarrierGatewayReference")
@software.amazon.jsii.Jsii.Proxy(CarrierGatewayReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CarrierGatewayReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CarrierGatewayId of the CarrierGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCarrierGatewayId();

    /**
     * @return a {@link Builder} of {@link CarrierGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CarrierGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CarrierGatewayReference> {
        java.lang.String carrierGatewayId;

        /**
         * Sets the value of {@link CarrierGatewayReference#getCarrierGatewayId}
         * @param carrierGatewayId The CarrierGatewayId of the CarrierGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder carrierGatewayId(java.lang.String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CarrierGatewayReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CarrierGatewayReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CarrierGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CarrierGatewayReference {
        private final java.lang.String carrierGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.carrierGatewayId = software.amazon.jsii.Kernel.get(this, "carrierGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.carrierGatewayId = java.util.Objects.requireNonNull(builder.carrierGatewayId, "carrierGatewayId is required");
        }

        @Override
        public final java.lang.String getCarrierGatewayId() {
            return this.carrierGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("carrierGatewayId", om.valueToTree(this.getCarrierGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.CarrierGatewayReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CarrierGatewayReference.Jsii$Proxy that = (CarrierGatewayReference.Jsii$Proxy) o;

            return this.carrierGatewayId.equals(that.carrierGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.carrierGatewayId.hashCode();
            return result;
        }
    }
}
