package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a EgressOnlyInternetGateway resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * EgressOnlyInternetGatewayReference egressOnlyInternetGatewayReference = EgressOnlyInternetGatewayReference.builder()
 *         .egressOnlyInternetGatewayId("egressOnlyInternetGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.EgressOnlyInternetGatewayReference")
@software.amazon.jsii.Jsii.Proxy(EgressOnlyInternetGatewayReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EgressOnlyInternetGatewayReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the EgressOnlyInternetGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEgressOnlyInternetGatewayId();

    /**
     * @return a {@link Builder} of {@link EgressOnlyInternetGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EgressOnlyInternetGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EgressOnlyInternetGatewayReference> {
        java.lang.String egressOnlyInternetGatewayId;

        /**
         * Sets the value of {@link EgressOnlyInternetGatewayReference#getEgressOnlyInternetGatewayId}
         * @param egressOnlyInternetGatewayId The Id of the EgressOnlyInternetGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressOnlyInternetGatewayId(java.lang.String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EgressOnlyInternetGatewayReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EgressOnlyInternetGatewayReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EgressOnlyInternetGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EgressOnlyInternetGatewayReference {
        private final java.lang.String egressOnlyInternetGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.egressOnlyInternetGatewayId = software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.egressOnlyInternetGatewayId = java.util.Objects.requireNonNull(builder.egressOnlyInternetGatewayId, "egressOnlyInternetGatewayId is required");
        }

        @Override
        public final java.lang.String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.EgressOnlyInternetGatewayReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EgressOnlyInternetGatewayReference.Jsii$Proxy that = (EgressOnlyInternetGatewayReference.Jsii$Proxy) o;

            return this.egressOnlyInternetGatewayId.equals(that.egressOnlyInternetGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.egressOnlyInternetGatewayId.hashCode();
            return result;
        }
    }
}
