package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a IPAMAllocation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * IPAMAllocationReference iPAMAllocationReference = Map.of(
 *         "cidr", "cidr",
 *         "ipamPoolAllocationId", "ipamPoolAllocationId",
 *         "ipamPoolId", "ipamPoolId");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.252Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.IPAMAllocationReference")
@software.amazon.jsii.Jsii.Proxy(IPAMAllocationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPAMAllocationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Cidr of the IPAMAllocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCidr();

    /**
     * The IpamPoolAllocationId of the IPAMAllocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamPoolAllocationId();

    /**
     * The IpamPoolId of the IPAMAllocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamPoolId();

    /**
     * @return a {@link Builder} of {@link IPAMAllocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IPAMAllocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IPAMAllocationReference> {
        java.lang.String cidr;
        java.lang.String ipamPoolAllocationId;
        java.lang.String ipamPoolId;

        /**
         * Sets the value of {@link IPAMAllocationReference#getCidr}
         * @param cidr The Cidr of the IPAMAllocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link IPAMAllocationReference#getIpamPoolAllocationId}
         * @param ipamPoolAllocationId The IpamPoolAllocationId of the IPAMAllocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamPoolAllocationId(java.lang.String ipamPoolAllocationId) {
            this.ipamPoolAllocationId = ipamPoolAllocationId;
            return this;
        }

        /**
         * Sets the value of {@link IPAMAllocationReference#getIpamPoolId}
         * @param ipamPoolId The IpamPoolId of the IPAMAllocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamPoolId(java.lang.String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IPAMAllocationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IPAMAllocationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IPAMAllocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPAMAllocationReference {
        private final java.lang.String cidr;
        private final java.lang.String ipamPoolAllocationId;
        private final java.lang.String ipamPoolId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamPoolAllocationId = software.amazon.jsii.Kernel.get(this, "ipamPoolAllocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamPoolId = software.amazon.jsii.Kernel.get(this, "ipamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            this.ipamPoolAllocationId = java.util.Objects.requireNonNull(builder.ipamPoolAllocationId, "ipamPoolAllocationId is required");
            this.ipamPoolId = java.util.Objects.requireNonNull(builder.ipamPoolId, "ipamPoolId is required");
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getIpamPoolAllocationId() {
            return this.ipamPoolAllocationId;
        }

        @Override
        public final java.lang.String getIpamPoolId() {
            return this.ipamPoolId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cidr", om.valueToTree(this.getCidr()));
            data.set("ipamPoolAllocationId", om.valueToTree(this.getIpamPoolAllocationId()));
            data.set("ipamPoolId", om.valueToTree(this.getIpamPoolId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.IPAMAllocationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IPAMAllocationReference.Jsii$Proxy that = (IPAMAllocationReference.Jsii$Proxy) o;

            if (!cidr.equals(that.cidr)) return false;
            if (!ipamPoolAllocationId.equals(that.ipamPoolAllocationId)) return false;
            return this.ipamPoolId.equals(that.ipamPoolId);
        }

        @Override
        public final int hashCode() {
            int result = this.cidr.hashCode();
            result = 31 * result + (this.ipamPoolAllocationId.hashCode());
            result = 31 * result + (this.ipamPoolId.hashCode());
            return result;
        }
    }
}
