package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a NetworkInsightsAnalysis resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * NetworkInsightsAnalysisReference networkInsightsAnalysisReference = NetworkInsightsAnalysisReference.builder()
 *         .networkInsightsAnalysisArn("networkInsightsAnalysisArn")
 *         .networkInsightsAnalysisId("networkInsightsAnalysisId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.285Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.NetworkInsightsAnalysisReference")
@software.amazon.jsii.Jsii.Proxy(NetworkInsightsAnalysisReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkInsightsAnalysisReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the NetworkInsightsAnalysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAnalysisArn();

    /**
     * The NetworkInsightsAnalysisId of the NetworkInsightsAnalysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAnalysisId();

    /**
     * @return a {@link Builder} of {@link NetworkInsightsAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkInsightsAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkInsightsAnalysisReference> {
        java.lang.String networkInsightsAnalysisArn;
        java.lang.String networkInsightsAnalysisId;

        /**
         * Sets the value of {@link NetworkInsightsAnalysisReference#getNetworkInsightsAnalysisArn}
         * @param networkInsightsAnalysisArn The ARN of the NetworkInsightsAnalysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAnalysisArn(java.lang.String networkInsightsAnalysisArn) {
            this.networkInsightsAnalysisArn = networkInsightsAnalysisArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkInsightsAnalysisReference#getNetworkInsightsAnalysisId}
         * @param networkInsightsAnalysisId The NetworkInsightsAnalysisId of the NetworkInsightsAnalysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAnalysisId(java.lang.String networkInsightsAnalysisId) {
            this.networkInsightsAnalysisId = networkInsightsAnalysisId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkInsightsAnalysisReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkInsightsAnalysisReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkInsightsAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInsightsAnalysisReference {
        private final java.lang.String networkInsightsAnalysisArn;
        private final java.lang.String networkInsightsAnalysisId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInsightsAnalysisArn = software.amazon.jsii.Kernel.get(this, "networkInsightsAnalysisArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInsightsAnalysisId = software.amazon.jsii.Kernel.get(this, "networkInsightsAnalysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInsightsAnalysisArn = java.util.Objects.requireNonNull(builder.networkInsightsAnalysisArn, "networkInsightsAnalysisArn is required");
            this.networkInsightsAnalysisId = java.util.Objects.requireNonNull(builder.networkInsightsAnalysisId, "networkInsightsAnalysisId is required");
        }

        @Override
        public final java.lang.String getNetworkInsightsAnalysisArn() {
            return this.networkInsightsAnalysisArn;
        }

        @Override
        public final java.lang.String getNetworkInsightsAnalysisId() {
            return this.networkInsightsAnalysisId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInsightsAnalysisArn", om.valueToTree(this.getNetworkInsightsAnalysisArn()));
            data.set("networkInsightsAnalysisId", om.valueToTree(this.getNetworkInsightsAnalysisId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.NetworkInsightsAnalysisReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkInsightsAnalysisReference.Jsii$Proxy that = (NetworkInsightsAnalysisReference.Jsii$Proxy) o;

            if (!networkInsightsAnalysisArn.equals(that.networkInsightsAnalysisArn)) return false;
            return this.networkInsightsAnalysisId.equals(that.networkInsightsAnalysisId);
        }

        @Override
        public final int hashCode() {
            int result = this.networkInsightsAnalysisArn.hashCode();
            result = 31 * result + (this.networkInsightsAnalysisId.hashCode());
            return result;
        }
    }
}
