package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a TrafficMirrorSession resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * TrafficMirrorSessionReference trafficMirrorSessionReference = TrafficMirrorSessionReference.builder()
 *         .trafficMirrorSessionId("trafficMirrorSessionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.293Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.TrafficMirrorSessionReference")
@software.amazon.jsii.Jsii.Proxy(TrafficMirrorSessionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrafficMirrorSessionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the TrafficMirrorSession resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficMirrorSessionId();

    /**
     * @return a {@link Builder} of {@link TrafficMirrorSessionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrafficMirrorSessionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrafficMirrorSessionReference> {
        java.lang.String trafficMirrorSessionId;

        /**
         * Sets the value of {@link TrafficMirrorSessionReference#getTrafficMirrorSessionId}
         * @param trafficMirrorSessionId The Id of the TrafficMirrorSession resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficMirrorSessionId(java.lang.String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrafficMirrorSessionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrafficMirrorSessionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrafficMirrorSessionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficMirrorSessionReference {
        private final java.lang.String trafficMirrorSessionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trafficMirrorSessionId = software.amazon.jsii.Kernel.get(this, "trafficMirrorSessionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trafficMirrorSessionId = java.util.Objects.requireNonNull(builder.trafficMirrorSessionId, "trafficMirrorSessionId is required");
        }

        @Override
        public final java.lang.String getTrafficMirrorSessionId() {
            return this.trafficMirrorSessionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trafficMirrorSessionId", om.valueToTree(this.getTrafficMirrorSessionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.TrafficMirrorSessionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrafficMirrorSessionReference.Jsii$Proxy that = (TrafficMirrorSessionReference.Jsii$Proxy) o;

            return this.trafficMirrorSessionId.equals(that.trafficMirrorSessionId);
        }

        @Override
        public final int hashCode() {
            int result = this.trafficMirrorSessionId.hashCode();
            return result;
        }
    }
}
