package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a TransitGatewayMulticastDomain resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * TransitGatewayMulticastDomainReference transitGatewayMulticastDomainReference = TransitGatewayMulticastDomainReference.builder()
 *         .transitGatewayMulticastDomainArn("transitGatewayMulticastDomainArn")
 *         .transitGatewayMulticastDomainId("transitGatewayMulticastDomainId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.304Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.TransitGatewayMulticastDomainReference")
@software.amazon.jsii.Jsii.Proxy(TransitGatewayMulticastDomainReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransitGatewayMulticastDomainReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the TransitGatewayMulticastDomain resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayMulticastDomainArn();

    /**
     * The TransitGatewayMulticastDomainId of the TransitGatewayMulticastDomain resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayMulticastDomainId();

    /**
     * @return a {@link Builder} of {@link TransitGatewayMulticastDomainReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransitGatewayMulticastDomainReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayMulticastDomainReference> {
        java.lang.String transitGatewayMulticastDomainArn;
        java.lang.String transitGatewayMulticastDomainId;

        /**
         * Sets the value of {@link TransitGatewayMulticastDomainReference#getTransitGatewayMulticastDomainArn}
         * @param transitGatewayMulticastDomainArn The ARN of the TransitGatewayMulticastDomain resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayMulticastDomainArn(java.lang.String transitGatewayMulticastDomainArn) {
            this.transitGatewayMulticastDomainArn = transitGatewayMulticastDomainArn;
            return this;
        }

        /**
         * Sets the value of {@link TransitGatewayMulticastDomainReference#getTransitGatewayMulticastDomainId}
         * @param transitGatewayMulticastDomainId The TransitGatewayMulticastDomainId of the TransitGatewayMulticastDomain resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayMulticastDomainId(java.lang.String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransitGatewayMulticastDomainReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransitGatewayMulticastDomainReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransitGatewayMulticastDomainReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayMulticastDomainReference {
        private final java.lang.String transitGatewayMulticastDomainArn;
        private final java.lang.String transitGatewayMulticastDomainId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.transitGatewayMulticastDomainArn = software.amazon.jsii.Kernel.get(this, "transitGatewayMulticastDomainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayMulticastDomainId = software.amazon.jsii.Kernel.get(this, "transitGatewayMulticastDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.transitGatewayMulticastDomainArn = java.util.Objects.requireNonNull(builder.transitGatewayMulticastDomainArn, "transitGatewayMulticastDomainArn is required");
            this.transitGatewayMulticastDomainId = java.util.Objects.requireNonNull(builder.transitGatewayMulticastDomainId, "transitGatewayMulticastDomainId is required");
        }

        @Override
        public final java.lang.String getTransitGatewayMulticastDomainArn() {
            return this.transitGatewayMulticastDomainArn;
        }

        @Override
        public final java.lang.String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("transitGatewayMulticastDomainArn", om.valueToTree(this.getTransitGatewayMulticastDomainArn()));
            data.set("transitGatewayMulticastDomainId", om.valueToTree(this.getTransitGatewayMulticastDomainId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.TransitGatewayMulticastDomainReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransitGatewayMulticastDomainReference.Jsii$Proxy that = (TransitGatewayMulticastDomainReference.Jsii$Proxy) o;

            if (!transitGatewayMulticastDomainArn.equals(that.transitGatewayMulticastDomainArn)) return false;
            return this.transitGatewayMulticastDomainId.equals(that.transitGatewayMulticastDomainId);
        }

        @Override
        public final int hashCode() {
            int result = this.transitGatewayMulticastDomainArn.hashCode();
            result = 31 * result + (this.transitGatewayMulticastDomainId.hashCode());
            return result;
        }
    }
}
