package software.amazon.awscdk.interfaces.ec2;

/**
 * A reference to a VerifiedAccessGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ec2.*;
 * VerifiedAccessGroupReference verifiedAccessGroupReference = VerifiedAccessGroupReference.builder()
 *         .verifiedAccessGroupArn("verifiedAccessGroupArn")
 *         .verifiedAccessGroupId("verifiedAccessGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.312Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ec2.VerifiedAccessGroupReference")
@software.amazon.jsii.Jsii.Proxy(VerifiedAccessGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VerifiedAccessGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the VerifiedAccessGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVerifiedAccessGroupArn();

    /**
     * The VerifiedAccessGroupId of the VerifiedAccessGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVerifiedAccessGroupId();

    /**
     * @return a {@link Builder} of {@link VerifiedAccessGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VerifiedAccessGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VerifiedAccessGroupReference> {
        java.lang.String verifiedAccessGroupArn;
        java.lang.String verifiedAccessGroupId;

        /**
         * Sets the value of {@link VerifiedAccessGroupReference#getVerifiedAccessGroupArn}
         * @param verifiedAccessGroupArn The ARN of the VerifiedAccessGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessGroupArn(java.lang.String verifiedAccessGroupArn) {
            this.verifiedAccessGroupArn = verifiedAccessGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link VerifiedAccessGroupReference#getVerifiedAccessGroupId}
         * @param verifiedAccessGroupId The VerifiedAccessGroupId of the VerifiedAccessGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessGroupId(java.lang.String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VerifiedAccessGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VerifiedAccessGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VerifiedAccessGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VerifiedAccessGroupReference {
        private final java.lang.String verifiedAccessGroupArn;
        private final java.lang.String verifiedAccessGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.verifiedAccessGroupArn = software.amazon.jsii.Kernel.get(this, "verifiedAccessGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.verifiedAccessGroupId = software.amazon.jsii.Kernel.get(this, "verifiedAccessGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.verifiedAccessGroupArn = java.util.Objects.requireNonNull(builder.verifiedAccessGroupArn, "verifiedAccessGroupArn is required");
            this.verifiedAccessGroupId = java.util.Objects.requireNonNull(builder.verifiedAccessGroupId, "verifiedAccessGroupId is required");
        }

        @Override
        public final java.lang.String getVerifiedAccessGroupArn() {
            return this.verifiedAccessGroupArn;
        }

        @Override
        public final java.lang.String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("verifiedAccessGroupArn", om.valueToTree(this.getVerifiedAccessGroupArn()));
            data.set("verifiedAccessGroupId", om.valueToTree(this.getVerifiedAccessGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ec2.VerifiedAccessGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VerifiedAccessGroupReference.Jsii$Proxy that = (VerifiedAccessGroupReference.Jsii$Proxy) o;

            if (!verifiedAccessGroupArn.equals(that.verifiedAccessGroupArn)) return false;
            return this.verifiedAccessGroupId.equals(that.verifiedAccessGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.verifiedAccessGroupArn.hashCode();
            result = 31 * result + (this.verifiedAccessGroupId.hashCode());
            return result;
        }
    }
}
