package software.amazon.awscdk.interfaces.ecr;

/**
 * A reference to a PublicRepository resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ecr.*;
 * PublicRepositoryReference publicRepositoryReference = PublicRepositoryReference.builder()
 *         .publicRepositoryArn("publicRepositoryArn")
 *         .repositoryName("repositoryName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.315Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ecr.PublicRepositoryReference")
@software.amazon.jsii.Jsii.Proxy(PublicRepositoryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicRepositoryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PublicRepository resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicRepositoryArn();

    /**
     * The RepositoryName of the PublicRepository resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link PublicRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicRepositoryReference> {
        java.lang.String publicRepositoryArn;
        java.lang.String repositoryName;

        /**
         * Sets the value of {@link PublicRepositoryReference#getPublicRepositoryArn}
         * @param publicRepositoryArn The ARN of the PublicRepository resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicRepositoryArn(java.lang.String publicRepositoryArn) {
            this.publicRepositoryArn = publicRepositoryArn;
            return this;
        }

        /**
         * Sets the value of {@link PublicRepositoryReference#getRepositoryName}
         * @param repositoryName The RepositoryName of the PublicRepository resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicRepositoryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicRepositoryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicRepositoryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicRepositoryReference {
        private final java.lang.String publicRepositoryArn;
        private final java.lang.String repositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publicRepositoryArn = software.amazon.jsii.Kernel.get(this, "publicRepositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publicRepositoryArn = java.util.Objects.requireNonNull(builder.publicRepositoryArn, "publicRepositoryArn is required");
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
        }

        @Override
        public final java.lang.String getPublicRepositoryArn() {
            return this.publicRepositoryArn;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publicRepositoryArn", om.valueToTree(this.getPublicRepositoryArn()));
            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ecr.PublicRepositoryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicRepositoryReference.Jsii$Proxy that = (PublicRepositoryReference.Jsii$Proxy) o;

            if (!publicRepositoryArn.equals(that.publicRepositoryArn)) return false;
            return this.repositoryName.equals(that.repositoryName);
        }

        @Override
        public final int hashCode() {
            int result = this.publicRepositoryArn.hashCode();
            result = 31 * result + (this.repositoryName.hashCode());
            return result;
        }
    }
}
