package software.amazon.awscdk.interfaces.eks;

/**
 * A reference to a AccessEntry resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.eks.*;
 * AccessEntryReference accessEntryReference = AccessEntryReference.builder()
 *         .accessEntryArn("accessEntryArn")
 *         .clusterName("clusterName")
 *         .principalArn("principalArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.323Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_eks.AccessEntryReference")
@software.amazon.jsii.Jsii.Proxy(AccessEntryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessEntryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AccessEntry resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessEntryArn();

    /**
     * The ClusterName of the AccessEntry resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The PrincipalArn of the AccessEntry resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipalArn();

    /**
     * @return a {@link Builder} of {@link AccessEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessEntryReference> {
        java.lang.String accessEntryArn;
        java.lang.String clusterName;
        java.lang.String principalArn;

        /**
         * Sets the value of {@link AccessEntryReference#getAccessEntryArn}
         * @param accessEntryArn The ARN of the AccessEntry resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessEntryArn(java.lang.String accessEntryArn) {
            this.accessEntryArn = accessEntryArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryReference#getClusterName}
         * @param clusterName The ClusterName of the AccessEntry resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link AccessEntryReference#getPrincipalArn}
         * @param principalArn The PrincipalArn of the AccessEntry resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalArn(java.lang.String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessEntryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessEntryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessEntryReference {
        private final java.lang.String accessEntryArn;
        private final java.lang.String clusterName;
        private final java.lang.String principalArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessEntryArn = software.amazon.jsii.Kernel.get(this, "accessEntryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principalArn = software.amazon.jsii.Kernel.get(this, "principalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessEntryArn = java.util.Objects.requireNonNull(builder.accessEntryArn, "accessEntryArn is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.principalArn = java.util.Objects.requireNonNull(builder.principalArn, "principalArn is required");
        }

        @Override
        public final java.lang.String getAccessEntryArn() {
            return this.accessEntryArn;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessEntryArn", om.valueToTree(this.getAccessEntryArn()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("principalArn", om.valueToTree(this.getPrincipalArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_eks.AccessEntryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessEntryReference.Jsii$Proxy that = (AccessEntryReference.Jsii$Proxy) o;

            if (!accessEntryArn.equals(that.accessEntryArn)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            return this.principalArn.equals(that.principalArn);
        }

        @Override
        public final int hashCode() {
            int result = this.accessEntryArn.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.principalArn.hashCode());
            return result;
        }
    }
}
