package software.amazon.awscdk.interfaces.elasticache;

/**
 * A reference to a ServerlessCache resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.elasticache.*;
 * ServerlessCacheReference serverlessCacheReference = ServerlessCacheReference.builder()
 *         .serverlessCacheName("serverlessCacheName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.344Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_elasticache.ServerlessCacheReference")
@software.amazon.jsii.Jsii.Proxy(ServerlessCacheReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServerlessCacheReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ServerlessCacheName of the ServerlessCache resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerlessCacheName();

    /**
     * @return a {@link Builder} of {@link ServerlessCacheReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServerlessCacheReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServerlessCacheReference> {
        java.lang.String serverlessCacheName;

        /**
         * Sets the value of {@link ServerlessCacheReference#getServerlessCacheName}
         * @param serverlessCacheName The ServerlessCacheName of the ServerlessCache resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessCacheName(java.lang.String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerlessCacheReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServerlessCacheReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServerlessCacheReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessCacheReference {
        private final java.lang.String serverlessCacheName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serverlessCacheName = software.amazon.jsii.Kernel.get(this, "serverlessCacheName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serverlessCacheName = java.util.Objects.requireNonNull(builder.serverlessCacheName, "serverlessCacheName is required");
        }

        @Override
        public final java.lang.String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serverlessCacheName", om.valueToTree(this.getServerlessCacheName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_elasticache.ServerlessCacheReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServerlessCacheReference.Jsii$Proxy that = (ServerlessCacheReference.Jsii$Proxy) o;

            return this.serverlessCacheName.equals(that.serverlessCacheName);
        }

        @Override
        public final int hashCode() {
            int result = this.serverlessCacheName.hashCode();
            return result;
        }
    }
}
