package software.amazon.awscdk.interfaces.events;

/**
 * A reference to a Archive resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.events.*;
 * ArchiveReference archiveReference = ArchiveReference.builder()
 *         .archiveArn("archiveArn")
 *         .archiveName("archiveName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.362Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_events.ArchiveReference")
@software.amazon.jsii.Jsii.Proxy(ArchiveReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ArchiveReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Archive resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArchiveArn();

    /**
     * The ArchiveName of the Archive resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArchiveName();

    /**
     * @return a {@link Builder} of {@link ArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ArchiveReference> {
        java.lang.String archiveArn;
        java.lang.String archiveName;

        /**
         * Sets the value of {@link ArchiveReference#getArchiveArn}
         * @param archiveArn The ARN of the Archive resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveArn(java.lang.String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        /**
         * Sets the value of {@link ArchiveReference#getArchiveName}
         * @param archiveName The ArchiveName of the Archive resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveName(java.lang.String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ArchiveReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ArchiveReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ArchiveReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveReference {
        private final java.lang.String archiveArn;
        private final java.lang.String archiveName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.archiveArn = software.amazon.jsii.Kernel.get(this, "archiveArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.archiveName = software.amazon.jsii.Kernel.get(this, "archiveName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.archiveArn = java.util.Objects.requireNonNull(builder.archiveArn, "archiveArn is required");
            this.archiveName = java.util.Objects.requireNonNull(builder.archiveName, "archiveName is required");
        }

        @Override
        public final java.lang.String getArchiveArn() {
            return this.archiveArn;
        }

        @Override
        public final java.lang.String getArchiveName() {
            return this.archiveName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("archiveArn", om.valueToTree(this.getArchiveArn()));
            data.set("archiveName", om.valueToTree(this.getArchiveName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_events.ArchiveReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ArchiveReference.Jsii$Proxy that = (ArchiveReference.Jsii$Proxy) o;

            if (!archiveArn.equals(that.archiveArn)) return false;
            return this.archiveName.equals(that.archiveName);
        }

        @Override
        public final int hashCode() {
            int result = this.archiveArn.hashCode();
            result = 31 * result + (this.archiveName.hashCode());
            return result;
        }
    }
}
