package software.amazon.awscdk.interfaces.events;

/**
 * A reference to a Endpoint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.events.*;
 * EndpointReference endpointReference = EndpointReference.builder()
 *         .endpointArn("endpointArn")
 *         .endpointName("endpointName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.363Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_events.EndpointReference")
@software.amazon.jsii.Jsii.Proxy(EndpointReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EndpointReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Endpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointArn();

    /**
     * The Name of the Endpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

    /**
     * @return a {@link Builder} of {@link EndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EndpointReference> {
        java.lang.String endpointArn;
        java.lang.String endpointName;

        /**
         * Sets the value of {@link EndpointReference#getEndpointArn}
         * @param endpointArn The ARN of the Endpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointArn(java.lang.String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        /**
         * Sets the value of {@link EndpointReference#getEndpointName}
         * @param endpointName The Name of the Endpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EndpointReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EndpointReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointReference {
        private final java.lang.String endpointArn;
        private final java.lang.String endpointName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointArn = software.amazon.jsii.Kernel.get(this, "endpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointArn = java.util.Objects.requireNonNull(builder.endpointArn, "endpointArn is required");
            this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
        }

        @Override
        public final java.lang.String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointArn", om.valueToTree(this.getEndpointArn()));
            data.set("endpointName", om.valueToTree(this.getEndpointName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_events.EndpointReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EndpointReference.Jsii$Proxy that = (EndpointReference.Jsii$Proxy) o;

            if (!endpointArn.equals(that.endpointArn)) return false;
            return this.endpointName.equals(that.endpointName);
        }

        @Override
        public final int hashCode() {
            int result = this.endpointArn.hashCode();
            result = 31 * result + (this.endpointName.hashCode());
            return result;
        }
    }
}
