package software.amazon.awscdk.interfaces.fis;

/**
 * A reference to a ExperimentTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.fis.*;
 * ExperimentTemplateReference experimentTemplateReference = ExperimentTemplateReference.builder()
 *         .experimentTemplateId("experimentTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-11-17T14:41:03.382Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_fis.ExperimentTemplateReference")
@software.amazon.jsii.Jsii.Proxy(ExperimentTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExperimentTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ExperimentTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExperimentTemplateId();

    /**
     * @return a {@link Builder} of {@link ExperimentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExperimentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExperimentTemplateReference> {
        java.lang.String experimentTemplateId;

        /**
         * Sets the value of {@link ExperimentTemplateReference#getExperimentTemplateId}
         * @param experimentTemplateId The Id of the ExperimentTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentTemplateId(java.lang.String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExperimentTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExperimentTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExperimentTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentTemplateReference {
        private final java.lang.String experimentTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.experimentTemplateId = software.amazon.jsii.Kernel.get(this, "experimentTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.experimentTemplateId = java.util.Objects.requireNonNull(builder.experimentTemplateId, "experimentTemplateId is required");
        }

        @Override
        public final java.lang.String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("experimentTemplateId", om.valueToTree(this.getExperimentTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_fis.ExperimentTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExperimentTemplateReference.Jsii$Proxy that = (ExperimentTemplateReference.Jsii$Proxy) o;

            return this.experimentTemplateId.equals(that.experimentTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.experimentTemplateId.hashCode();
            return result;
        }
    }
}
